/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.servlet.lifecycle;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.qi4j.api.Qi4j;
import org.qi4j.api.common.InvalidApplicationException;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.ApplicationDescriptor;
import org.qi4j.bootstrap.ApplicationAssembler;
import org.qi4j.bootstrap.Energy4Java;
import org.qi4j.library.servlet.Qi4jServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQi4jServletBootstrap
implements ServletContextListener,
ApplicationAssembler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Qi4jServlet.class.getPackage().getName());
    protected Qi4j api;
    protected Energy4Java qi4j;
    protected ApplicationDescriptor applicationModel;
    protected Application application;

    public final void contextInitialized(ServletContextEvent sce) {
        try {
            ServletContext context = sce.getServletContext();
            LOGGER.trace("Assembling Application");
            this.qi4j = new Energy4Java();
            this.applicationModel = this.qi4j.newApplicationModel((ApplicationAssembler)this);
            LOGGER.trace("Instanciating and activating Application");
            this.application = this.applicationModel.newInstance(this.qi4j.api(), new Object[0]);
            this.api = this.qi4j.api();
            this.beforeApplicationActivation(this.application);
            this.application.activate();
            this.afterApplicationActivation(this.application);
            LOGGER.trace("Storing Application in ServletContext");
            context.setAttribute("qi4j-application-servlet-context-attribute", (Object)this.application);
        }
        catch (Exception ex) {
            if (this.application != null) {
                try {
                    this.beforeApplicationPassivation(this.application);
                    this.application.passivate();
                    this.afterApplicationPassivation(this.application);
                }
                catch (Exception ex1) {
                    LOGGER.warn("Application not null and could not passivate it.", (Throwable)ex1);
                }
            }
            throw new InvalidApplicationException("Unexpected error during ServletContext initialization, see previous log for errors.", (Throwable)ex);
        }
    }

    protected void beforeApplicationActivation(Application app) {
    }

    protected void afterApplicationActivation(Application app) {
    }

    public final void contextDestroyed(ServletContextEvent sce) {
        try {
            if (this.application != null) {
                this.beforeApplicationPassivation(this.application);
                this.application.passivate();
                this.afterApplicationPassivation(this.application);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to passivate Zest Application.", (Throwable)ex);
        }
    }

    protected void beforeApplicationPassivation(Application app) {
    }

    protected void afterApplicationPassivation(Application app) {
    }
}

