/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.elasticsearch;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.service.qualifier.Tagged;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.usecase.UsecaseBuilder;
import org.qi4j.api.util.Classes;
import org.qi4j.api.value.ValueSerializer;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.index.elasticsearch.ElasticSearchIndexException;
import org.qi4j.index.elasticsearch.ElasticSearchSupport;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entity.ManyAssociationState;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.entitystore.EntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.StateChangeListener;
import org.qi4j.spi.module.ModuleSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={Mixin.class})
public interface ElasticSearchIndexer
extends StateChangeListener {

    public static class Mixin
    implements StateChangeListener {
        private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchIndexer.class);
        @Structure
        private ModuleSpi module;
        @Service
        private EntityStore entityStore;
        @Service
        @Tagged(value={"json"})
        private ValueSerializer valueSerializer;
        @This
        private ElasticSearchSupport support;

        public void emptyIndex() {
            this.support.client().admin().indices().prepareDelete(new String[]{this.support.index()}).execute().actionGet();
        }

        public void notifyChanges(Iterable<EntityState> changedStates) {
            HashMap<String, EntityState> newStates = new HashMap<String, EntityState>();
            for (EntityState eState : changedStates) {
                if (eState.status() != EntityStatus.UPDATED && eState.status() != EntityStatus.NEW) continue;
                newStates.put(eState.identity().identity(), eState);
            }
            EntityStoreUnitOfWork uow = this.entityStore.newUnitOfWork(UsecaseBuilder.newUsecase((String)"Load associations for indexing"), this.module, System.currentTimeMillis());
            BulkRequestBuilder bulkBuilder = this.support.client().prepareBulk();
            for (EntityState changedState : changedStates) {
                if (!changedState.entityDescriptor().queryable()) continue;
                switch (changedState.status()) {
                    case REMOVED: {
                        LOGGER.trace("Removing Entity State from Index: {}", (Object)changedState);
                        this.remove(bulkBuilder, changedState.identity().identity());
                        break;
                    }
                    case UPDATED: {
                        LOGGER.trace("Updating Entity State in Index: {}", (Object)changedState);
                        this.remove(bulkBuilder, changedState.identity().identity());
                        String updatedJson = this.toJSON(changedState, newStates, uow);
                        LOGGER.trace("Will index: {}", (Object)updatedJson);
                        this.index(bulkBuilder, changedState.identity().identity(), updatedJson);
                        break;
                    }
                    case NEW: {
                        LOGGER.trace("Creating Entity State in Index: {}", (Object)changedState);
                        String newJson = this.toJSON(changedState, newStates, uow);
                        LOGGER.trace("Will index: {}", (Object)newJson);
                        this.index(bulkBuilder, changedState.identity().identity(), newJson);
                        break;
                    }
                }
            }
            uow.discard();
            if (bulkBuilder.numberOfActions() > 0) {
                BulkResponse bulkResponse = (BulkResponse)bulkBuilder.execute().actionGet();
                if (bulkResponse.hasFailures()) {
                    throw new ElasticSearchIndexException(bulkResponse.buildFailureMessage());
                }
                LOGGER.debug("Indexing changed Entity states took {}ms", (Object)bulkResponse.getTookInMillis());
                this.support.client().admin().indices().prepareRefresh(new String[]{this.support.index()}).execute().actionGet();
            }
        }

        private void remove(BulkRequestBuilder bulkBuilder, String identity) {
            bulkBuilder.add(this.support.client().prepareDelete(this.support.index(), this.support.entitiesType(), identity));
        }

        private void index(BulkRequestBuilder bulkBuilder, String identity, String json) {
            bulkBuilder.add(this.support.client().prepareIndex(this.support.index(), this.support.entitiesType(), identity).setSource(json));
        }

        private String toJSON(EntityState state, Map<String, EntityState> newStates, EntityStoreUnitOfWork uow) {
            try {
                ManyAssociationState associateds;
                JSONArray array;
                String key;
                JSONObject json = new JSONObject();
                json.put("_identity", (Object)state.identity().identity());
                json.put("_types", (Collection)Iterables.toList((Iterable)Iterables.map((Function)Classes.toClassName(), (Iterable)state.entityDescriptor().mixinTypes())));
                EntityDescriptor entityType = state.entityDescriptor();
                for (PropertyDescriptor propDesc : entityType.state().properties()) {
                    if (!propDesc.queryable()) continue;
                    key = propDesc.qualifiedName().name();
                    Object value = state.propertyValueOf(propDesc.qualifiedName());
                    if (value == null || ValueType.isPrimitiveValue((Object)value)) {
                        json.put(key, value);
                        continue;
                    }
                    String serialized = this.valueSerializer.serialize(new ValueSerializer.Options().withoutTypeInfo(), value);
                    if (serialized.startsWith("{")) {
                        json.put(key, (Object)new JSONObject(serialized));
                        continue;
                    }
                    if (serialized.startsWith("[")) {
                        json.put(key, (Object)new JSONArray(serialized));
                        continue;
                    }
                    json.put(key, (Object)serialized);
                }
                for (AssociationDescriptor assocDesc : entityType.state().associations()) {
                    JSONObject value;
                    if (!assocDesc.queryable()) continue;
                    key = assocDesc.qualifiedName().name();
                    EntityReference associated = state.associationValueOf(assocDesc.qualifiedName());
                    if (associated == null) {
                        value = null;
                    } else if (assocDesc.isAggregated() || this.support.indexNonAggregatedAssociations()) {
                        if (newStates.containsKey(associated.identity())) {
                            value = new JSONObject(this.toJSON(newStates.get(associated.identity()), newStates, uow));
                        } else {
                            EntityReference reference = EntityReference.parseEntityReference((String)associated.identity());
                            EntityState assocState = uow.entityStateOf(this.module, reference);
                            value = new JSONObject(this.toJSON(assocState, newStates, uow));
                        }
                    } else {
                        value = new JSONObject(Collections.singletonMap("identity", associated.identity()));
                    }
                    json.put(key, value);
                }
                for (AssociationDescriptor manyAssocDesc : entityType.state().manyAssociations()) {
                    if (!manyAssocDesc.queryable()) continue;
                    key = manyAssocDesc.qualifiedName().name();
                    array = new JSONArray();
                    associateds = state.manyAssociationValueOf(manyAssocDesc.qualifiedName());
                    for (EntityReference associated : associateds) {
                        if (manyAssocDesc.isAggregated() || this.support.indexNonAggregatedAssociations()) {
                            if (newStates.containsKey(associated.identity())) {
                                array.put((Object)new JSONObject(this.toJSON(newStates.get(associated.identity()), newStates, uow)));
                                continue;
                            }
                            EntityReference reference = EntityReference.parseEntityReference((String)associated.identity());
                            EntityState assocState = uow.entityStateOf(this.module, reference);
                            array.put((Object)new JSONObject(this.toJSON(assocState, newStates, uow)));
                            continue;
                        }
                        array.put((Object)new JSONObject(Collections.singletonMap("identity", associated.identity())));
                    }
                    json.put(key, (Object)array);
                }
                for (AssociationDescriptor namedAssocDesc : entityType.state().namedAssociations()) {
                    if (!namedAssocDesc.queryable()) continue;
                    key = namedAssocDesc.qualifiedName().name();
                    array = new JSONArray();
                    associateds = state.namedAssociationValueOf(namedAssocDesc.qualifiedName());
                    for (String name : associateds) {
                        if (namedAssocDesc.isAggregated() || this.support.indexNonAggregatedAssociations()) {
                            String identity = associateds.get(name).identity();
                            if (newStates.containsKey(identity)) {
                                JSONObject obj = new JSONObject(this.toJSON(newStates.get(identity), newStates, uow));
                                obj.put("_named", (Object)name);
                                array.put((Object)obj);
                                continue;
                            }
                            EntityReference reference = EntityReference.parseEntityReference((String)identity);
                            EntityState assocState = uow.entityStateOf(this.module, reference);
                            JSONObject obj = new JSONObject(this.toJSON(assocState, newStates, uow));
                            obj.put("_named", (Object)name);
                            array.put((Object)obj);
                            continue;
                        }
                        JSONObject obj = new JSONObject();
                        obj.put("_named", (Object)name);
                        obj.put("identity", (Object)associateds.get(name).identity());
                        array.put((Object)obj);
                    }
                    json.put(key, (Object)array);
                }
                return json.toString();
            }
            catch (JSONException e) {
                throw new ElasticSearchIndexException("Could not index EntityState", e);
            }
        }
    }
}

