/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.elasticsearch.cluster;

import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.This;
import org.qi4j.index.elasticsearch.ElasticSearchClusterConfiguration;
import org.qi4j.index.elasticsearch.internal.AbstractElasticSearchSupport;

public class ESClusterSupport
extends AbstractElasticSearchSupport {
    @This
    private Configuration<ElasticSearchClusterConfiguration> configuration;

    @Override
    protected void activateElasticSearch() throws Exception {
        String[] stringArray;
        this.configuration.refresh();
        ElasticSearchClusterConfiguration config = (ElasticSearchClusterConfiguration)this.configuration.get();
        String clusterName = config.clusterName().get() == null ? "qi4j_cluster" : (String)config.clusterName().get();
        this.index = config.index().get() == null ? "qi4j_index" : (String)config.index().get();
        this.indexNonAggregatedAssociations = (Boolean)config.indexNonAggregatedAssociations().get();
        if (config.nodes().get() == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "localhost:9300";
        } else {
            stringArray = ((String)config.nodes().get()).split(",");
        }
        String[] nodes = stringArray;
        boolean clusterSniff = (Boolean)config.clusterSniff().get();
        boolean ignoreClusterName = (Boolean)config.ignoreClusterName().get();
        String pingTimeout = config.pingTimeout().get() == null ? "5s" : (String)config.pingTimeout().get();
        String samplerInterval = config.samplerInterval().get() == null ? "5s" : (String)config.samplerInterval().get();
        Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", clusterName).put("client.transport.sniff", clusterSniff).put("client.transport.ignore_cluster_name", ignoreClusterName).put("client.transport.ping_timeout", pingTimeout).put("client.transport.nodes_sampler_interval", samplerInterval).build();
        TransportClient transportClient = new TransportClient(settings);
        for (String node : nodes) {
            String[] split = node.split(":");
            String host = split[0];
            int port = Integer.valueOf(split[1]);
            transportClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(host, port));
        }
        this.client = transportClient;
    }
}

