/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.elasticsearch.internal;

import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.qi4j.index.elasticsearch.ElasticSearchSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractElasticSearchSupport
implements ElasticSearchSupport {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchSupport.class);
    protected static final String DEFAULT_CLUSTER_NAME = "qi4j_cluster";
    protected static final String DEFAULT_INDEX_NAME = "qi4j_index";
    protected static final String ENTITIES_TYPE = "qi4j_entities";
    protected Client client;
    protected String index;
    protected boolean indexNonAggregatedAssociations;

    public final void activateService() throws Exception {
        this.activateElasticSearch();
        this.client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet();
        if (!((IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{this.index}).setIndices(new String[]{this.index}).execute().actionGet()).isExists()) {
            LOGGER.info("Will create '{}' index as it does not exists.", (Object)this.index);
            ImmutableSettings.Builder indexSettings = ImmutableSettings.settingsBuilder().loadFromSource(XContentFactory.jsonBuilder().startObject().startObject("analysis").startObject("analyzer").startObject("default").field("type", "keyword").endObject().endObject().endObject().endObject().string());
            this.client.admin().indices().prepareCreate(this.index).setIndex(this.index).setSettings((Settings.Builder)indexSettings).execute().actionGet();
            LOGGER.info("Index '{}' created.", (Object)this.index);
        }
        this.client.admin().indices().prepareRefresh(new String[]{this.index}).execute().actionGet();
        this.client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet();
        LOGGER.info("Index/Query connected to Elastic Search");
    }

    protected abstract void activateElasticSearch() throws Exception;

    public final void passivateService() throws Exception {
        this.client.close();
        this.client = null;
        this.index = null;
        this.indexNonAggregatedAssociations = false;
        this.passivateElasticSearch();
    }

    protected void passivateElasticSearch() throws Exception {
    }

    @Override
    public final Client client() {
        return this.client;
    }

    @Override
    public final String index() {
        return this.index;
    }

    @Override
    public final String entitiesType() {
        return ENTITIES_TYPE;
    }

    @Override
    public final boolean indexNonAggregatedAssociations() {
        return this.indexNonAggregatedAssociations;
    }
}

