/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.service.ServiceActivation;
import org.qi4j.entitystore.mongodb.MongoAccessors;
import org.qi4j.entitystore.mongodb.MongoEntityStoreConfiguration;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.spi.entitystore.EntityNotFoundException;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.helpers.MapEntityStore;

public class MongoMapEntityStoreMixin
implements ServiceActivation,
MapEntityStore,
MongoAccessors {
    private static final String DEFAULT_DATABASE_NAME = "qi4j:entitystore";
    private static final String DEFAULT_COLLECTION_NAME = "qi4j:entitystore:entities";
    public static final String IDENTITY_COLUMN = "_id";
    public static final String STATE_COLUMN = "state";
    @This
    private Configuration<MongoEntityStoreConfiguration> configuration;
    private List<ServerAddress> serverAddresses;
    private String databaseName;
    private String collectionName;
    private WriteConcern writeConcern;
    private String username;
    private char[] password;
    private MongoClient mongo;
    private DB db;

    public void activateService() throws Exception {
        this.loadConfiguration();
        if (this.username.isEmpty()) {
            this.mongo = new MongoClient(this.serverAddresses);
        } else {
            MongoCredential credential = MongoCredential.createMongoCRCredential((String)this.username, (String)this.databaseName, (char[])this.password);
            this.mongo = new MongoClient(this.serverAddresses, Arrays.asList(credential));
        }
        this.db = this.mongo.getDB(this.databaseName);
        this.db.requestStart();
        DBCollection entities = this.db.getCollection(this.collectionName);
        if (entities.getIndexInfo().isEmpty()) {
            entities.createIndex((DBObject)new BasicDBObject(IDENTITY_COLUMN, (Object)1));
        }
        this.db.requestDone();
    }

    private void loadConfiguration() throws UnknownHostException {
        int port;
        this.configuration.refresh();
        MongoEntityStoreConfiguration config = (MongoEntityStoreConfiguration)this.configuration.get();
        this.serverAddresses = new ArrayList<ServerAddress>();
        int n = port = config.port().get() == null ? 27017 : (Integer)config.port().get();
        if (((List)config.nodes().get()).isEmpty()) {
            String hostname = config.hostname().get() == null ? "127.0.0.1" : (String)config.hostname().get();
            this.serverAddresses.add(new ServerAddress(hostname, port));
        } else {
            if (config.hostname().get() != null && !((String)config.hostname().get()).isEmpty()) {
                this.serverAddresses.add(new ServerAddress((String)config.hostname().get(), port));
            }
            this.serverAddresses.addAll((Collection)config.nodes().get());
        }
        this.databaseName = (String)config.database().get();
        if (this.databaseName == null) {
            this.databaseName = DEFAULT_DATABASE_NAME;
        }
        this.collectionName = (String)config.collection().get();
        if (this.collectionName == null) {
            this.collectionName = DEFAULT_COLLECTION_NAME;
        }
        switch ((MongoEntityStoreConfiguration.WriteConcern)((Object)config.writeConcern().get())) {
            case FSYNC_SAFE: {
                this.writeConcern = WriteConcern.FSYNC_SAFE;
                break;
            }
            case JOURNAL_SAFE: {
                this.writeConcern = WriteConcern.JOURNAL_SAFE;
                break;
            }
            case MAJORITY: {
                this.writeConcern = WriteConcern.MAJORITY;
                break;
            }
            case REPLICAS_SAFE: {
                this.writeConcern = WriteConcern.REPLICAS_SAFE;
                break;
            }
            case SAFE: {
                this.writeConcern = WriteConcern.SAFE;
                break;
            }
            default: {
                this.writeConcern = WriteConcern.NORMAL;
            }
        }
        this.username = (String)config.username().get();
        this.password = ((String)config.password().get()).toCharArray();
    }

    public void passivateService() throws Exception {
        this.mongo.close();
        this.mongo = null;
        this.databaseName = null;
        this.collectionName = null;
        this.writeConcern = null;
        this.username = null;
        Arrays.fill(this.password, ' ');
        this.password = null;
        this.db = null;
    }

    @Override
    public MongoClient mongoInstanceUsed() {
        return this.mongo;
    }

    @Override
    public DB dbInstanceUsed() {
        return this.db;
    }

    @Override
    public String collectionUsed() {
        return this.collectionName;
    }

    public Reader get(EntityReference entityReference) throws EntityStoreException {
        this.db.requestStart();
        DBObject entity = this.db.getCollection(this.collectionName).findOne(this.byIdentity(entityReference));
        if (entity == null) {
            throw new EntityNotFoundException(entityReference);
        }
        DBObject bsonState = (DBObject)entity.get(STATE_COLUMN);
        this.db.requestDone();
        String jsonState = JSON.serialize((Object)bsonState);
        return new StringReader(jsonState);
    }

    public void applyChanges(MapEntityStore.MapChanges changes) throws IOException {
        this.db.requestStart();
        final DBCollection entities = this.db.getCollection(this.collectionName);
        changes.visitMap(new MapEntityStore.MapChanger(){

            public Writer newEntity(final EntityReference ref, EntityDescriptor entityDescriptor) throws IOException {
                return new StringWriter(1000){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        String jsonState = this.toString();
                        DBObject bsonState = (DBObject)JSON.parse((String)jsonState);
                        BasicDBObject entity = new BasicDBObject();
                        entity.put(MongoMapEntityStoreMixin.IDENTITY_COLUMN, (Object)ref.identity());
                        entity.put(MongoMapEntityStoreMixin.STATE_COLUMN, (Object)bsonState);
                        entities.insert((DBObject)entity, MongoMapEntityStoreMixin.this.writeConcern);
                    }
                };
            }

            public Writer updateEntity(final EntityReference ref, EntityDescriptor entityDescriptor) throws IOException {
                return new StringWriter(1000){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        DBObject bsonState = (DBObject)JSON.parse((String)this.toString());
                        BasicDBObject entity = new BasicDBObject();
                        entity.put(MongoMapEntityStoreMixin.IDENTITY_COLUMN, (Object)ref.identity());
                        entity.put(MongoMapEntityStoreMixin.STATE_COLUMN, (Object)bsonState);
                        entities.update(MongoMapEntityStoreMixin.this.byIdentity(ref), (DBObject)entity, false, false, MongoMapEntityStoreMixin.this.writeConcern);
                    }
                };
            }

            public void removeEntity(EntityReference ref, EntityDescriptor entityDescriptor) throws EntityNotFoundException {
                DBObject entity = entities.findOne(MongoMapEntityStoreMixin.this.byIdentity(ref));
                if (entity == null) {
                    throw new EntityNotFoundException(ref);
                }
                entities.remove(entity, MongoMapEntityStoreMixin.this.writeConcern);
            }
        });
        this.db.requestDone();
    }

    public Input<Reader, IOException> entityStates() {
        return new Input<Reader, IOException>(){

            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super Reader, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                output.receiveFrom((Sender)new Sender<Reader, IOException>(){

                    public <ReceiverThrowableType extends Throwable> void sendTo(Receiver<? super Reader, ReceiverThrowableType> receiver) throws ReceiverThrowableType, IOException {
                        MongoMapEntityStoreMixin.this.db.requestStart();
                        DBCursor cursor = MongoMapEntityStoreMixin.this.db.getCollection(MongoMapEntityStoreMixin.this.collectionName).find();
                        while (cursor.hasNext()) {
                            DBObject eachEntity = cursor.next();
                            DBObject bsonState = (DBObject)eachEntity.get(MongoMapEntityStoreMixin.STATE_COLUMN);
                            String jsonState = JSON.serialize((Object)bsonState);
                            receiver.receive((Object)new StringReader(jsonState));
                        }
                        MongoMapEntityStoreMixin.this.db.requestDone();
                    }
                });
            }
        };
    }

    private DBObject byIdentity(EntityReference entityReference) {
        return new BasicDBObject(IDENTITY_COLUMN, (Object)entityReference.identity());
    }
}

