/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.uid.sequence;

import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.property.Property;
import org.qi4j.api.unitofwork.ConcurrentEntityModificationException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.library.uid.sequence.Sequence;
import org.qi4j.library.uid.sequence.Sequencing;
import org.qi4j.library.uid.sequence.SequencingException;

public class PersistedSequencingMixin
implements Sequencing {
    @Structure
    private UnitOfWorkFactory uowf;
    @This
    private Configuration<Sequence> sequence;

    @Override
    public Long newSequenceValue() throws SequencingException {
        PersistedSequencingMixin persistedSequencingMixin = this;
        synchronized (persistedSequencingMixin) {
            ConcurrentEntityModificationException exc = null;
            UnitOfWork uow = this.uowf.newUnitOfWork();
            try {
                for (int i = 0; i < 3; ++i) {
                    try {
                        Property<Long> property = ((Sequence)this.sequence.get()).currentValue();
                        long value = (Long)property.get();
                        property.set((Object)(++value));
                        uow.complete();
                        return value;
                    }
                    catch (ConcurrentEntityModificationException e) {
                        exc = e;
                        continue;
                    }
                }
                throw new SequencingException("Unable to update sequence value.", exc);
            }
            catch (UnitOfWorkCompletionException e) {
                throw new SequencingException("Unable to update sequence value.", exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long currentSequenceValue() {
        PersistedSequencingMixin persistedSequencingMixin = this;
        synchronized (persistedSequencingMixin) {
            return (Long)((Sequence)this.sequence.get()).currentValue().get();
        }
    }
}

