/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;
import org.qi4j.functional.Visitor;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;

public class Inputs {
    public static Input<String, RuntimeException> text(final String source) {
        return new Input<String, RuntimeException>(){

            @Override
            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super String, ReceiverThrowableType> output) throws RuntimeException, ReceiverThrowableType {
                output.receiveFrom(new Sender<String, RuntimeException>(){

                    @Override
                    public <Receiver2ThrowableType extends Throwable> void sendTo(Receiver<? super String, Receiver2ThrowableType> receiver) throws Receiver2ThrowableType, RuntimeException {
                        Scanner scanner = new Scanner(source);
                        while (scanner.hasNextLine()) {
                            receiver.receive(scanner.nextLine());
                        }
                    }
                });
            }
        };
    }

    public static Input<String, RuntimeException> text(final Reader source) {
        return new Input<String, RuntimeException>(){

            @Override
            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super String, ReceiverThrowableType> output) throws RuntimeException, ReceiverThrowableType {
                output.receiveFrom(new Sender<String, RuntimeException>(){

                    @Override
                    public <Receiver2ThrowableType extends Throwable> void sendTo(Receiver<? super String, Receiver2ThrowableType> receiver) throws Receiver2ThrowableType, RuntimeException {
                        Scanner scanner = new Scanner(source);
                        while (scanner.hasNextLine()) {
                            receiver.receive(scanner.nextLine());
                        }
                    }
                });
            }
        };
    }

    public static Input<String, IOException> text(File source) {
        return Inputs.text(source, "UTF-8");
    }

    public static Input<String, IOException> text(final File source, final String encoding) {
        return new Input<String, IOException>(){

            @Override
            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super String, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                InputStream stream = new FileInputStream(source);
                if (source.getName().endsWith(".gz")) {
                    stream = new GZIPInputStream(stream);
                }
                try (final BufferedReader reader = new BufferedReader(new InputStreamReader(stream, encoding));){
                    output.receiveFrom(new Sender<String, IOException>(){

                        @Override
                        public <Receiver2ThrowableType extends Throwable> void sendTo(Receiver<? super String, Receiver2ThrowableType> receiver) throws Receiver2ThrowableType, IOException {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                receiver.receive(line);
                            }
                        }
                    });
                }
            }
        };
    }

    public static Input<String, IOException> text(final URL source) {
        return new Input<String, IOException>(){

            @Override
            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super String, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                URLConnection urlConnection = source.openConnection();
                urlConnection.setRequestProperty("Accept-Encoding", "gzip");
                InputStream stream = urlConnection.getInputStream();
                if ("gzip".equals(urlConnection.getContentEncoding())) {
                    stream = new GZIPInputStream(stream);
                }
                String contentType = urlConnection.getContentType();
                String charSet = "UTF-8";
                if (contentType.contains("charset=")) {
                    charSet = contentType.substring(contentType.indexOf("charset=") + "charset=".length());
                }
                try (final BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charSet));){
                    output.receiveFrom(new Sender<String, IOException>(){

                        @Override
                        public <Receiver2ThrowableType extends Throwable> void sendTo(Receiver<? super String, Receiver2ThrowableType> receiver) throws Receiver2ThrowableType, IOException {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                receiver.receive(line);
                            }
                        }
                    });
                }
            }
        };
    }

    public static Input<ByteBuffer, IOException> byteBuffer(final File source, final int bufferSize) {
        return new Input<ByteBuffer, IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super ByteBuffer, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                FileInputStream stream = new FileInputStream(source);
                final FileChannel fci = stream.getChannel();
                final ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
                try {
                    output.receiveFrom(new Sender<ByteBuffer, IOException>(){

                        @Override
                        public <Receiver2ThrowableType extends Throwable> void sendTo(Receiver<? super ByteBuffer, Receiver2ThrowableType> receiver) throws Receiver2ThrowableType, IOException {
                            while (fci.read(buffer) != -1) {
                                buffer.flip();
                                receiver.receive(buffer);
                                buffer.clear();
                            }
                        }
                    });
                }
                finally {
                    stream.close();
                }
            }
        };
    }

    public static Input<ByteBuffer, IOException> byteBuffer(final InputStream source, final int bufferSize) {
        return new Input<ByteBuffer, IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super ByteBuffer, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                try {
                    output.receiveFrom(new Sender<ByteBuffer, IOException>(){

                        @Override
                        public <Receiver2ThrowableType extends Throwable> void sendTo(Receiver<? super ByteBuffer, Receiver2ThrowableType> receiver) throws Receiver2ThrowableType, IOException {
                            int len;
                            byte[] buffer = new byte[bufferSize];
                            while ((len = source.read(buffer)) != -1) {
                                ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, 0, len);
                                receiver.receive(byteBuffer);
                            }
                        }
                    });
                }
                finally {
                    source.close();
                }
            }
        };
    }

    public static <T, SenderThrowableType extends Throwable> Input<T, SenderThrowableType> combine(final Iterable<Input<T, SenderThrowableType>> inputs) {
        return new Input<T, SenderThrowableType>(){

            @Override
            public <Receiver2ThrowableType extends Throwable> void transferTo(Output<? super T, Receiver2ThrowableType> output) throws Throwable, Throwable {
                output.receiveFrom(new Sender<T, SenderThrowableType>(){

                    @Override
                    public <ReceiverThrowableType extends Throwable> void sendTo(final Receiver<? super T, ReceiverThrowableType> receiver) throws Throwable, Throwable {
                        for (Input input : inputs) {
                            input.transferTo(new Output<T, ReceiverThrowableType>(){

                                @Override
                                public <Sender2ThrowableType extends Throwable> void receiveFrom(Sender<? extends T, Sender2ThrowableType> sender) throws Throwable, Throwable {
                                    sender.sendTo(new Receiver<T, ReceiverThrowableType>(){

                                        @Override
                                        public void receive(T item) throws Throwable {
                                            receiver.receive(item);
                                        }
                                    });
                                }
                            });
                        }
                    }
                });
            }
        };
    }

    public static <T> Input<T, RuntimeException> iterable(final Iterable<T> iterable) {
        return new Input<T, RuntimeException>(){

            @Override
            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super T, ReceiverThrowableType> output) throws RuntimeException, ReceiverThrowableType {
                output.receiveFrom(new Sender<T, RuntimeException>(){

                    @Override
                    public <Receiver2ThrowableType extends Throwable> void sendTo(Receiver<? super T, Receiver2ThrowableType> receiver) throws Receiver2ThrowableType, RuntimeException {
                        for (Object item : iterable) {
                            receiver.receive(item);
                        }
                    }
                });
            }
        };
    }

    public static Input<ByteBuffer, IOException> output(final Visitor<OutputStream, IOException> outputVisitor, final int bufferSize) {
        return new Input<ByteBuffer, IOException>(){

            @Override
            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super ByteBuffer, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                output.receiveFrom(new Sender<ByteBuffer, IOException>(){

                    @Override
                    public <Receiver2ThrowableType extends Throwable> void sendTo(final Receiver<? super ByteBuffer, Receiver2ThrowableType> receiver) throws Receiver2ThrowableType, IOException {
                        try (BufferedOutputStream out = new BufferedOutputStream(new OutputStream(){

                            @Override
                            public void write(int b) throws IOException {
                            }

                            @Override
                            public void write(byte[] b, int off, int len) throws IOException {
                                try {
                                    ByteBuffer byteBuffer = ByteBuffer.wrap(b, 0, len);
                                    receiver.receive(byteBuffer);
                                }
                                catch (Throwable ex) {
                                    throw new IOException(ex);
                                }
                            }
                        }, bufferSize);){
                            outputVisitor.visit((Object)out);
                        }
                        catch (IOException ex) {
                            throw ex.getCause();
                        }
                    }
                });
            }
        };
    }

    private Inputs() {
    }
}

