/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.bootstrap;

import org.qi4j.bootstrap.Qi4jRuntime;

public interface RuntimeFactory {
    public Qi4jRuntime createRuntime();

    public static final class StandaloneApplicationRuntimeFactory
    implements RuntimeFactory {
        @Override
        public Qi4jRuntime createRuntime() {
            ClassLoader loader = this.getClass().getClassLoader();
            try {
                Class<? extends Qi4jRuntime> runtimeClass = this.loadRuntimeClass(loader);
                return runtimeClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                System.err.println("Zest Runtime jar is not present in the classpath.");
            }
            catch (IllegalAccessException | InstantiationException e) {
                System.err.println("Invalid Zest Runtime class. If you are providing your own Zest Runtime, please contact qi4j-dev at Google Groups for assistance.");
            }
            return null;
        }

        private Class<? extends Qi4jRuntime> loadRuntimeClass(ClassLoader loader) throws ClassNotFoundException {
            return loader.loadClass("org.qi4j.runtime.Qi4jRuntimeImpl");
        }
    }
}

