/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.bootstrap.builder;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.api.activation.ActivationEventListener;
import org.qi4j.api.activation.ActivationEventListenerRegistration;
import org.qi4j.api.activation.ActivationException;
import org.qi4j.api.activation.ApplicationPassivationThread;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.ApplicationDescriptor;
import org.qi4j.bootstrap.ApplicationAssembler;
import org.qi4j.bootstrap.ApplicationAssembly;
import org.qi4j.bootstrap.ApplicationAssemblyFactory;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.Energy4Java;
import org.qi4j.bootstrap.LayerAssembly;
import org.qi4j.bootstrap.builder.LayerDeclaration;
import org.qi4j.bootstrap.builder.ModuleDeclaration;

public class ApplicationBuilder
implements ActivationEventListenerRegistration {
    private final String applicationName;
    private final Map<String, LayerDeclaration> layers = new HashMap<String, LayerDeclaration>();
    private final List<ActivationEventListener> activationListeners = new ArrayList<ActivationEventListener>();

    public ApplicationBuilder(String applicationName) {
        this.applicationName = applicationName;
    }

    public Application newApplication() throws AssemblyException, ActivationException {
        Energy4Java qi4j = new Energy4Java();
        ApplicationDescriptor model = qi4j.newApplicationModel(new ApplicationAssembler(){

            @Override
            public ApplicationAssembly assemble(ApplicationAssemblyFactory factory) throws AssemblyException {
                ApplicationAssembly assembly = factory.newApplicationAssembly();
                assembly.setName(ApplicationBuilder.this.applicationName);
                HashMap<String, LayerAssembly> createdLayers = new HashMap<String, LayerAssembly>();
                for (Map.Entry entry : ApplicationBuilder.this.layers.entrySet()) {
                    LayerAssembly layer = ((LayerDeclaration)entry.getValue()).createLayer(assembly);
                    createdLayers.put((String)entry.getKey(), layer);
                }
                for (LayerDeclaration layer : ApplicationBuilder.this.layers.values()) {
                    layer.initialize(createdLayers);
                }
                return assembly;
            }
        });
        Application application = model.newInstance(qi4j.api(), new Object[0]);
        for (ActivationEventListener activationListener : this.activationListeners) {
            application.registerActivationEventListener(activationListener);
        }
        this.beforeActivation();
        application.activate();
        this.afterActivation();
        return application;
    }

    protected void beforeActivation() {
    }

    protected void afterActivation() {
    }

    public void registerActivationEventListener(ActivationEventListener listener) {
        this.activationListeners.add(listener);
    }

    public void deregisterActivationEventListener(ActivationEventListener listener) {
        this.activationListeners.remove(listener);
    }

    public LayerDeclaration withLayer(String layerName) {
        LayerDeclaration layerDeclaration = this.layers.get(layerName);
        if (layerDeclaration != null) {
            return layerDeclaration;
        }
        layerDeclaration = new LayerDeclaration(layerName);
        this.layers.put(layerName, layerDeclaration);
        return layerDeclaration;
    }

    public static ApplicationBuilder fromJson(String json) throws JSONException, AssemblyException {
        JSONObject root = new JSONObject(json);
        return ApplicationBuilder.fromJson(root);
    }

    public static ApplicationBuilder fromJson(InputStream json) throws JSONException, AssemblyException {
        String jsonString = new Scanner(json, "UTF-8").useDelimiter("\\A").next();
        return ApplicationBuilder.fromJson(jsonString);
    }

    public static ApplicationBuilder fromJson(JSONObject root) throws JSONException, AssemblyException {
        String applicationName = root.getString("name");
        ApplicationBuilder builder = new ApplicationBuilder(applicationName);
        builder.configureWithJson(root);
        return builder;
    }

    protected void configureWithJson(JSONObject root) throws JSONException, AssemblyException {
        JSONArray layers = root.optJSONArray("layers");
        if (layers != null) {
            for (int i = 0; i < layers.length(); ++i) {
                JSONArray modules;
                JSONObject layerObject = layers.getJSONObject(i);
                String layerName = layerObject.getString("name");
                LayerDeclaration layerDeclaration = this.withLayer(layerName);
                JSONArray using = layerObject.optJSONArray("uses");
                if (using != null) {
                    for (int j = 0; j < using.length(); ++j) {
                        layerDeclaration.using(using.getString(j));
                    }
                }
                if ((modules = layerObject.optJSONArray("modules")) == null) continue;
                for (int k = 0; k < modules.length(); ++k) {
                    JSONObject moduleObject = modules.getJSONObject(k);
                    String moduleName = moduleObject.getString("name");
                    ModuleDeclaration moduleDeclaration = layerDeclaration.withModule(moduleName);
                    JSONArray assemblers = moduleObject.optJSONArray("assemblers");
                    if (assemblers == null) continue;
                    for (int m = 0; m < assemblers.length(); ++m) {
                        String string = assemblers.getString(m);
                        moduleDeclaration.withAssembler(string);
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws JSONException, ActivationException, AssemblyException {
        ApplicationBuilder builder = ApplicationBuilder.fromJson(System.in);
        Application application = builder.newApplication();
        Runtime.getRuntime().addShutdownHook((Thread)new ApplicationPassivationThread(application, System.err));
    }
}

