/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.bootstrap.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qi4j.bootstrap.ApplicationAssembly;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.LayerAssembly;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.bootstrap.builder.ModuleDeclaration;
import org.qi4j.functional.Iterables;

public class LayerDeclaration {
    private final String layerName;
    private final List<String> using = new ArrayList<String>();
    private final Map<String, ModuleDeclaration> modules = new HashMap<String, ModuleDeclaration>();
    private LayerAssembly layer;

    LayerDeclaration(String layerName) {
        this.layerName = layerName;
    }

    public LayerDeclaration using(String layerName) {
        this.using.add(layerName);
        return this;
    }

    public LayerDeclaration using(Iterable<String> layerNames) {
        Iterables.addAll(this.using, layerNames);
        return this;
    }

    public ModuleDeclaration withModule(String moduleName) {
        ModuleDeclaration module = this.modules.get(moduleName);
        if (module != null) {
            return module;
        }
        module = new ModuleDeclaration(moduleName);
        this.modules.put(moduleName, module);
        return module;
    }

    LayerAssembly createLayer(ApplicationAssembly application) {
        this.layer = application.layer(this.layerName);
        this.layer.setName(this.layerName);
        for (ModuleDeclaration module : this.modules.values()) {
            ModuleAssembly assembly = module.createModule(this.layer);
        }
        return this.layer;
    }

    void initialize(HashMap<String, LayerAssembly> createdLayers) throws AssemblyException {
        for (String uses : this.using) {
            LayerAssembly usedLayer = createdLayers.get(uses);
            this.layer.uses(usedLayer);
        }
        for (ModuleDeclaration module : this.modules.values()) {
            module.initialize();
        }
    }
}

