/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.bootstrap.builder;

import java.util.ArrayList;
import java.util.List;
import org.qi4j.api.util.Classes;
import org.qi4j.bootstrap.Assembler;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.LayerAssembly;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;

public class ModuleDeclaration {
    private final String moduleName;
    private final List<Assembler> assemblers = new ArrayList<Assembler>();
    private ModuleAssembly module;

    public ModuleDeclaration(String moduleName) {
        this.moduleName = moduleName;
    }

    public ModuleDeclaration withAssembler(Assembler assembler) {
        this.assemblers.add(assembler);
        return this;
    }

    public ModuleDeclaration withAssembler(String classname) throws AssemblyException {
        Class<? extends Assembler> clazz = this.loadClass(classname);
        return this.withAssembler(clazz);
    }

    public ModuleDeclaration withAssembler(Class<?> assemblerClass) throws AssemblyException {
        Assembler assembler = this.createAssemblerInstance(assemblerClass);
        this.assemblers.add(assembler);
        return this;
    }

    public ModuleDeclaration withAssemblers(Iterable<Class<?>> assemblerClasses) throws AssemblyException {
        List notAssemblers = Iterables.toList((Iterable)Iterables.filter((Specification)Specifications.not((Specification)Classes.isAssignableFrom(Assembler.class)), assemblerClasses));
        if (!notAssemblers.isEmpty()) {
            throw new AssemblyException("Classes " + notAssemblers + " are not implementing " + Assembler.class.getName());
        }
        for (Class<?> assemblerClass : assemblerClasses) {
            this.withAssembler(assemblerClass);
        }
        return this;
    }

    ModuleAssembly createModule(LayerAssembly layer) {
        this.module = layer.module(this.moduleName);
        return this.module;
    }

    void initialize() throws AssemblyException {
        for (Assembler assembler : this.assemblers) {
            assembler.assemble(this.module);
        }
    }

    private Class<? extends Assembler> loadClass(String classname) throws AssemblyException {
        Class<?> clazz;
        try {
            clazz = this.getClass().getClassLoader().loadClass(classname);
        }
        catch (Exception e) {
            throw new AssemblyException("Unable to load class " + classname, e);
        }
        if (!Assembler.class.isAssignableFrom(clazz)) {
            throw new AssemblyException("Class " + classname + " is not implementing " + Assembler.class.getName());
        }
        return clazz;
    }

    private Assembler createAssemblerInstance(Class<?> assemblerClass) throws AssemblyException {
        if (!Assembler.class.isAssignableFrom(assemblerClass)) {
            throw new AssemblyException("Class " + assemblerClass + " is not implementing " + Assembler.class.getName());
        }
        try {
            return (Assembler)assemblerClass.newInstance();
        }
        catch (Exception e) {
            throw new AssemblyException("Unable to instantiate " + assemblerClass, e);
        }
    }
}

