/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.bootstrap.layered;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.qi4j.api.Qi4j;
import org.qi4j.api.activation.ActivationException;
import org.qi4j.api.activation.PassivationException;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.ApplicationDescriptor;
import org.qi4j.bootstrap.ApplicationAssembler;
import org.qi4j.bootstrap.ApplicationAssembly;
import org.qi4j.bootstrap.ApplicationAssemblyFactory;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.Energy4Java;
import org.qi4j.bootstrap.LayerAssembly;
import org.qi4j.bootstrap.layered.LayerAssembler;

public abstract class LayeredApplicationAssembler
implements ApplicationAssembler {
    protected Application application;
    protected String name;
    protected String version;
    private final Application.Mode mode;
    private ApplicationAssembly assembly;
    private HashMap<Class<? extends LayerAssembler>, LayerAssembler> assemblers = new HashMap();

    public LayeredApplicationAssembler(String name, String version, Application.Mode mode) throws AssemblyException {
        this.name = name;
        this.version = version;
        this.mode = mode;
        Energy4Java qi4j = new Energy4Java();
        ApplicationDescriptor model = qi4j.newApplicationModel(this);
        this.onModelCreated(model);
        this.instantiateApplication(qi4j, model);
    }

    public ApplicationAssembly assembly() {
        return this.assembly;
    }

    protected void instantiateApplication(Energy4Java qi4j, ApplicationDescriptor model) {
        this.application = model.newInstance((Qi4j)qi4j.spi(), new Object[0]);
    }

    protected void onModelCreated(ApplicationDescriptor model) {
    }

    public Application application() {
        return this.application;
    }

    public void start() throws ActivationException {
        this.application.activate();
    }

    public void stop() throws PassivationException {
        this.application.passivate();
    }

    @Override
    public ApplicationAssembly assemble(ApplicationAssemblyFactory applicationFactory) throws AssemblyException {
        this.assembly = applicationFactory.newApplicationAssembly();
        this.assembly.setName(this.name);
        this.assembly.setVersion(this.version);
        this.assembly.setMode(this.mode);
        this.assembleLayers(this.assembly);
        return this.assembly;
    }

    protected LayerAssembly createLayer(Class<? extends LayerAssembler> layerAssemblerClass) throws IllegalArgumentException {
        try {
            String classname = layerAssemblerClass.getSimpleName();
            if (classname.endsWith("Layer")) {
                classname = classname.substring(0, classname.length() - 5) + " Layer";
            }
            LayeredApplicationAssembler.setNameIfPresent(layerAssemblerClass, classname);
            LayerAssembly layer = this.assembly.layer(classname);
            LayerAssembler layerAssembler = this.instantiateAssembler(layerAssemblerClass, layer);
            this.assemblers.put(layerAssemblerClass, layerAssembler);
            LayerAssembly assembly = layerAssembler.assemble(layer);
            if (assembly == null) {
                return layer;
            }
            return assembly;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate layer with " + layerAssemblerClass.getSimpleName(), e);
        }
    }

    private LayerAssembler instantiateAssembler(Class<? extends LayerAssembler> layerAssemblerClass, LayerAssembly layer) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        LayerAssembler layerAssembler;
        try {
            Constructor<? extends LayerAssembler> assemblyConstructor = layerAssemblerClass.getConstructor(LayerAssembly.class);
            layerAssembler = assemblyConstructor.newInstance(layer);
        }
        catch (NoSuchMethodException e) {
            layerAssembler = layerAssemblerClass.newInstance();
        }
        return layerAssembler;
    }

    static void setNameIfPresent(Class<?> clazz, String classname) throws IllegalAccessException {
        try {
            Field field = clazz.getDeclaredField("NAME");
            if (Modifier.isStatic(field.getModifiers())) {
                field.setAccessible(true);
                field.set(null, classname);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected <T extends LayerAssembler> T assemblerOf(Class<T> layerAssemblerClass) {
        return (T)this.assemblers.get(layerAssemblerClass);
    }

    protected abstract void assembleLayers(ApplicationAssembly var1) throws AssemblyException;
}

