/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.alarm;

import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.Property;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.library.alarm.AlarmModel;
import org.qi4j.library.alarm.AlarmStatus;

@Mixins(value={Mixin.class})
public interface AlarmEvent
extends ValueComposite {
    public Property<String> alarmIdentity();

    public Property<AlarmStatus> oldStatus();

    public Property<AlarmStatus> newStatus();

    public Property<Date> eventTime();

    public Property<String> systemName();

    public String name(Locale var1);

    public String description(Locale var1);

    public static abstract class Mixin
    implements AlarmEvent {
        @Service
        private AlarmModel model;

        @Override
        public String name(Locale locale) {
            ResourceBundle bundle = ResourceBundle.getBundle((String)((ServiceComposite)this.model).identity().get(), locale);
            return bundle.getString((String)this.systemName().get());
        }

        @Override
        public String description(Locale locale) {
            ResourceBundle bundle = ResourceBundle.getBundle((String)((ServiceComposite)this.model).identity().get(), locale);
            String eventDescriptionId = "EVENT_" + ((String)this.systemName().get()).toUpperCase() + "_DESCRIPTION";
            return bundle.getString(eventDescriptionId);
        }
    }
}

