/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.alarm;

import java.util.List;
import java.util.Map;
import org.qi4j.api.common.UseDefaults;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.Property;
import org.qi4j.library.alarm.AlarmEvent;

@Mixins(value={AlarmHistoryMixin.class})
public interface AlarmHistory {
    public AlarmEvent lastEvent();

    public AlarmEvent firstEvent();

    public AlarmEvent eventAt(int var1);

    public AlarmEvent eventAtEnd(int var1);

    @UseDefaults
    public Property<List<AlarmEvent>> allAlarmEvents();

    @UseDefaults
    public Property<Integer> maxSize();

    @UseDefaults
    public Property<Map<String, Integer>> counters();

    public void resetAllCounters();

    public int activateCounter();

    public void resetActivateCounter();

    public void addEvent(AlarmEvent var1, String var2);

    public static abstract class AlarmHistoryMixin
    implements AlarmHistory {
        @Override
        public AlarmEvent firstEvent() {
            List eventList = (List)this.allAlarmEvents().get();
            if (eventList.isEmpty()) {
                return null;
            }
            return (AlarmEvent)eventList.get(0);
        }

        @Override
        public AlarmEvent lastEvent() {
            List eventList = (List)this.allAlarmEvents().get();
            if (eventList.isEmpty()) {
                return null;
            }
            return (AlarmEvent)eventList.get(eventList.size() - 1);
        }

        @Override
        public AlarmEvent eventAt(int position) {
            List eventList = (List)this.allAlarmEvents().get();
            if (eventList.size() <= position || position < 0) {
                return null;
            }
            return (AlarmEvent)eventList.get(position);
        }

        @Override
        public AlarmEvent eventAtEnd(int position) {
            List eventList = (List)this.allAlarmEvents().get();
            int size = eventList.size();
            if (size <= position || position < 0) {
                return null;
            }
            return (AlarmEvent)eventList.get(size - position - 1);
        }

        @Override
        public void addEvent(AlarmEvent event, String trigger) {
            List eventList = (List)this.allAlarmEvents().get();
            eventList.add(event);
            this.purge();
            this.allAlarmEvents().set((Object)eventList);
            Map counters = (Map)this.counters().get();
            Integer counter = (Integer)counters.get(trigger);
            counter = counter == null ? Integer.valueOf(1) : Integer.valueOf(counter + 1);
            counters.put(trigger, counter);
            this.counters().set((Object)counters);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("history[maxsize=");
            buf.append(this.maxSize().get());
            buf.append(", size=");
            buf.append(((List)this.allAlarmEvents().get()).size());
            for (Map.Entry entry : ((Map)this.counters().get()).entrySet()) {
                String type = (String)entry.getKey();
                Integer counts = (Integer)entry.getValue();
                buf.append(", ");
                buf.append(type);
                buf.append("=");
                buf.append(counts);
            }
            buf.append("]");
            return buf.toString();
        }

        private void purge() {
            List eventList = (List)this.allAlarmEvents().get();
            Integer maxSize = (Integer)this.maxSize().get();
            if (maxSize <= 0) {
                eventList.clear();
            }
            while (eventList.size() > maxSize) {
                eventList.remove(0);
            }
        }

        @Override
        public void resetAllCounters() {
            Map counters = (Map)this.counters().get();
            counters.clear();
            this.counters().set((Object)counters);
        }

        @Override
        public int activateCounter() {
            Integer counter = (Integer)((Map)this.counters().get()).get("activate");
            if (counter == null) {
                return 0;
            }
            return counter;
        }

        @Override
        public void resetActivateCounter() {
            Map counters = (Map)this.counters().get();
            counters.remove("activate");
            this.counters().set((Object)counters);
        }
    }
}

