/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.alarm;

import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.library.alarm.AlarmCategory;
import org.qi4j.library.alarm.AlarmClass;
import org.qi4j.library.alarm.AlarmPoint;
import org.qi4j.library.alarm.AlarmStatus;

@Mixins(value={Mixin.class})
public interface AlarmPointFactory
extends ServiceComposite {
    public AlarmPoint create(String var1, String var2, String var3, AlarmClass var4);

    public static abstract class Mixin
    implements AlarmPointFactory {
        @Structure
        private Module module;

        @Override
        public AlarmPoint create(String identity, String systemName, String categoryName, AlarmClass alarmClass) {
            UnitOfWork uow = this.module.currentUnitOfWork();
            EntityBuilder builder = uow.newEntityBuilder(AlarmPoint.class, identity);
            ((AlarmPoint)builder.instance()).category().set((Object)this.createCategory(categoryName));
            ((AlarmPoint)builder.instance()).alarmClass().set((Object)alarmClass);
            AlarmPoint.AlarmState prototype = (AlarmPoint.AlarmState)builder.instanceFor(AlarmPoint.AlarmState.class);
            AlarmStatus normal = this.createNormalAlarmStatus();
            prototype.systemName().set((Object)systemName);
            prototype.currentStatus().set((Object)normal);
            return (AlarmPoint)builder.newInstance();
        }

        private AlarmStatus createNormalAlarmStatus() {
            ValueBuilder builder = this.module.newValueBuilder(AlarmStatus.class);
            ((AlarmStatus.State)builder.prototypeFor(AlarmStatus.State.class)).name().set((Object)"Normal");
            return (AlarmStatus)builder.newInstance();
        }

        private AlarmCategory createCategory(String categoryName) {
            ValueBuilder builder = this.module.newValueBuilder(AlarmCategory.class);
            ((AlarmCategory)builder.prototype()).name().set((Object)categoryName);
            return (AlarmCategory)builder.newInstance();
        }
    }
}

