/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.alarm;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.query.Query;
import org.qi4j.api.query.QueryBuilder;
import org.qi4j.api.query.QueryBuilderFactory;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueBuilderFactory;
import org.qi4j.library.alarm.AlarmCategory;
import org.qi4j.library.alarm.AlarmEvent;
import org.qi4j.library.alarm.AlarmListener;
import org.qi4j.library.alarm.AlarmModel;
import org.qi4j.library.alarm.AlarmModelDescriptor;
import org.qi4j.library.alarm.AlarmPoint;
import org.qi4j.library.alarm.AlarmStatus;

@Mixins(value={AlarmSystemMixin.class})
public interface AlarmSystem {
    public List<AlarmModelDescriptor> alarmModels();

    public AlarmModel defaultAlarmModel();

    public Query<AlarmPoint> alarmList();

    public AlarmPoint createAlarm(String var1, AlarmCategory var2);

    public void addAlarmListener(AlarmListener var1);

    public void removeAlarmListener(AlarmListener var1);

    public List<AlarmListener> alarmListeners();

    public static class AlarmSystemMixin
    implements AlarmSystem {
        @Service
        private Iterable<ServiceReference<AlarmModel>> models;
        private final CopyOnWriteArrayList<AlarmListener> alarmListeners = new CopyOnWriteArrayList();
        @Structure
        private UnitOfWorkFactory uowf;
        @Structure
        private ValueBuilderFactory vbf;
        @Structure
        private QueryBuilderFactory qbf;

        @Override
        public List<AlarmModelDescriptor> alarmModels() {
            ArrayList<AlarmModelDescriptor> descriptors = new ArrayList<AlarmModelDescriptor>();
            for (ServiceReference<AlarmModel> model : this.models) {
                descriptors.add((AlarmModelDescriptor)model.metaInfo(AlarmModelDescriptor.class));
            }
            return descriptors;
        }

        @Override
        public AlarmModel defaultAlarmModel() {
            AlarmModelDescriptor defaultDefault = null;
            for (AlarmModelDescriptor descriptor : this.alarmModels()) {
                if (descriptor.isDefaultModel()) {
                    return this.alarmModel(descriptor);
                }
                defaultDefault = descriptor;
            }
            return this.alarmModel(defaultDefault);
        }

        private AlarmModel alarmModel(AlarmModelDescriptor descriptor) {
            for (ServiceReference<AlarmModel> model : this.models) {
                if (!((AlarmModelDescriptor)model.metaInfo(AlarmModelDescriptor.class)).equals(descriptor)) continue;
                return (AlarmModel)model.get();
            }
            return null;
        }

        @Override
        public AlarmPoint createAlarm(String name, AlarmCategory category) {
            UnitOfWork uow = this.uowf.currentUnitOfWork();
            EntityBuilder builder = uow.newEntityBuilder(AlarmPoint.class);
            ((AlarmPoint)builder.instance()).category().set((Object)category);
            AlarmPoint.AlarmState state = (AlarmPoint.AlarmState)builder.instanceFor(AlarmPoint.AlarmState.class);
            state.systemName().set((Object)name);
            state.currentStatus().set((Object)this.createStatus("Normal"));
            return (AlarmPoint)builder.newInstance();
        }

        private AlarmStatus createStatus(String status) {
            ValueBuilder builder = this.vbf.newValueBuilder(AlarmStatus.class);
            AlarmStatus.State statePrototype = (AlarmStatus.State)builder.prototypeFor(AlarmStatus.State.class);
            statePrototype.name().set((Object)status);
            statePrototype.creationDate().set((Object)new Date());
            return (AlarmStatus)builder.newInstance();
        }

        @Override
        public void addAlarmListener(AlarmListener listener) {
            this.alarmListeners.add(listener);
        }

        @Override
        public void removeAlarmListener(AlarmListener listener) {
            this.alarmListeners.remove(listener);
        }

        @Override
        public Query<AlarmPoint> alarmList() {
            UnitOfWork uow = this.uowf.currentUnitOfWork();
            QueryBuilder builder = this.qbf.newQueryBuilder(AlarmPoint.class);
            return uow.newQuery(builder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<AlarmListener> alarmListeners() {
            CopyOnWriteArrayList<AlarmListener> copyOnWriteArrayList = this.alarmListeners;
            synchronized (copyOnWriteArrayList) {
                return this.alarmListeners;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarmFired(AlarmEvent event) {
            Iterator<AlarmListener> list;
            CopyOnWriteArrayList<AlarmListener> copyOnWriteArrayList = this.alarmListeners;
            synchronized (copyOnWriteArrayList) {
                list = this.alarmListeners.iterator();
            }
            while (list.hasNext()) {
                AlarmListener listener = list.next();
                try {
                    listener.alarmFired(event);
                }
                catch (Exception e) {
                    System.err.println("Exception in AlarmListener: " + listener);
                    e.printStackTrace();
                }
            }
        }
    }
}

