/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.alarm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueBuilderFactory;
import org.qi4j.library.alarm.AlarmEvent;
import org.qi4j.library.alarm.AlarmModel;
import org.qi4j.library.alarm.AlarmPoint;
import org.qi4j.library.alarm.AlarmStatus;

@Mixins(value={StandardAlarmModelMixin.class})
public interface StandardAlarmModelService
extends AlarmModel,
ServiceComposite {

    public static class StandardAlarmModelMixin
    implements AlarmModel {
        private static final List<String> TRIGGER_LIST;
        private static final List<String> STATUS_LIST;
        @Structure
        private ValueBuilderFactory vbf;

        static ResourceBundle getResourceBundle(Locale locale) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ClassLoader cl = StandardAlarmModelMixin.class.getClassLoader();
            return ResourceBundle.getBundle("org.qi4j.library.alarm.AlarmResources", locale, cl);
        }

        @Override
        public String modelName() {
            return "org.qi4j.library.alarm.model.standard";
        }

        @Override
        public String modelDescription() {
            return this.modelDescription(null);
        }

        @Override
        public String modelDescription(Locale locale) {
            ResourceBundle rb = StandardAlarmModelMixin.getResourceBundle(locale);
            return rb.getString("MODEL_DESCRIPTION_STANDARD");
        }

        @Override
        public AlarmEvent evaluate(AlarmPoint alarm, String trigger) {
            if (trigger.equals("activate")) {
                return this.activation(alarm);
            }
            if (trigger.equals("deactivate")) {
                return this.deactivation(alarm);
            }
            if (trigger.equals("acknowledge")) {
                return this.acknowledge(alarm);
            }
            throw new IllegalArgumentException("'" + trigger + "' is not supported by this AlarmModel.");
        }

        @Override
        public List<String> alarmTriggers() {
            return TRIGGER_LIST;
        }

        @Override
        public List<String> statusList() {
            return STATUS_LIST;
        }

        @Override
        public String computeTrigger(AlarmStatus status, boolean condition) {
            if (condition) {
                if (status.name(null).equals("Deactivated") || status.name(null).equals("Normal")) {
                    return "activate";
                }
            } else if (status.name(null).equals("Activated") || status.name(null).equals("Acknowledged")) {
                return "deactivate";
            }
            return null;
        }

        @Override
        public boolean computeCondition(AlarmStatus status) {
            return status.name(null).equals("Activated") || status.name(null).equals("Acknowledged");
        }

        private AlarmEvent activation(AlarmPoint alarm) {
            AlarmStatus oldStatus = alarm.currentStatus();
            if (oldStatus.name(null).equals("Normal") || oldStatus.name(null).equals("Deactivated")) {
                AlarmStatus newStatus = this.createStatus("Activated");
                return this.createEvent((Identity)alarm, oldStatus, newStatus, "activation");
            }
            return null;
        }

        private AlarmEvent deactivation(AlarmPoint alarm) {
            AlarmStatus oldStatus = alarm.currentStatus();
            if (oldStatus.name(null).equals("Acknowledged")) {
                AlarmStatus newStatus = this.createStatus("Normal");
                return this.createEvent((Identity)alarm, oldStatus, newStatus, "deactivation");
            }
            if (oldStatus.name(null).equals("Activated")) {
                AlarmStatus newStatus = this.createStatus("Deactivated");
                return this.createEvent((Identity)alarm, oldStatus, newStatus, "deactivation");
            }
            return null;
        }

        private AlarmEvent acknowledge(AlarmPoint alarm) {
            AlarmStatus oldStatus = alarm.currentStatus();
            if (oldStatus.name(null).equals("Deactivated")) {
                AlarmStatus newStatus = this.createStatus("Normal");
                return this.createEvent((Identity)alarm, oldStatus, newStatus, "acknowledgement");
            }
            if (oldStatus.name(null).equals("Activated")) {
                AlarmStatus newStatus = this.createStatus("Acknowledged");
                return this.createEvent((Identity)alarm, oldStatus, newStatus, "acknowledgement");
            }
            return null;
        }

        private AlarmStatus createStatus(String status) {
            ValueBuilder builder = this.vbf.newValueBuilder(AlarmStatus.class);
            AlarmStatus.State prototype = (AlarmStatus.State)builder.prototypeFor(AlarmStatus.State.class);
            prototype.name().set((Object)status);
            prototype.creationDate().set((Object)new Date());
            return (AlarmStatus)builder.newInstance();
        }

        private AlarmEvent createEvent(Identity alarmId, AlarmStatus oldStatus, AlarmStatus newStatus, String eventSystemName) {
            ValueBuilder builder = this.vbf.newValueBuilder(AlarmEvent.class);
            AlarmEvent prototype = (AlarmEvent)builder.prototype();
            prototype.alarmIdentity().set(alarmId.identity().get());
            prototype.eventTime().set((Object)new Date());
            prototype.newStatus().set((Object)newStatus);
            prototype.oldStatus().set((Object)oldStatus);
            prototype.systemName().set((Object)eventSystemName);
            return (AlarmEvent)builder.newInstance();
        }

        static {
            ArrayList<String> list1 = new ArrayList<String>();
            list1.add("Normal");
            list1.add("Activated");
            list1.add("Deactivated");
            list1.add("Acknowledged");
            STATUS_LIST = Collections.unmodifiableList(list1);
            ArrayList<String> list2 = new ArrayList<String>();
            list2.add("activate");
            list2.add("deactivate");
            list2.add("acknowledge");
            TRIGGER_LIST = Collections.unmodifiableList(list2);
        }
    }
}

