/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.conversion.values;

import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.AssociationStateDescriptor;
import org.qi4j.api.association.AssociationStateHolder;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.NoSuchValueException;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueDescriptor;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.library.conversion.values.Shared;
import org.qi4j.library.conversion.values.Unqualified;
import org.qi4j.spi.Qi4jSPI;

@Mixins(value={EntityToValueMixin.class})
public interface EntityToValue {
    public <T> T convert(Class<T> var1, Object var2);

    public <T> T convert(Class<T> var1, Object var2, Function<T, T> var3);

    public <T> Iterable<T> convert(Class<T> var1, Iterable<Object> var2);

    public <T> Iterable<T> convert(Class<T> var1, Iterable<Object> var2, Function<T, T> var3);

    public static class EntityToValueMixin
    implements EntityToValue {
        @Structure
        private Qi4jSPI spi;
        @Structure
        private Module module;

        @Override
        public <T> T convert(Class<T> valueType, Object entity) {
            return this.createInstance(this.doConversion(valueType, entity));
        }

        @Override
        public <T> T convert(Class<T> valueType, Object entity, Function<T, T> prototypeOpportunity) {
            ValueBuilder<?> builder = this.doConversion(valueType, entity);
            prototypeOpportunity.map(builder.prototype());
            return this.createInstance(builder);
        }

        @Override
        public <T> Iterable<T> convert(final Class<T> valueType, Iterable<Object> entities) {
            return Iterables.map((Function)new Function<Object, T>(){

                public T map(Object entity) {
                    return EntityToValueMixin.this.convert(valueType, entity);
                }
            }, entities);
        }

        @Override
        public <T> Iterable<T> convert(final Class<T> valueType, Iterable<Object> entities, final Function<T, T> prototypeOpportunity) {
            return Iterables.map((Function)new Function<Object, T>(){

                public T map(Object entity) {
                    return EntityToValueMixin.this.convert(valueType, entity, prototypeOpportunity);
                }
            }, entities);
        }

        private <T> ValueBuilder<?> doConversion(Class<T> valueType, Object entity) {
            ValueDescriptor valueDescriptor = this.module.valueDescriptor(valueType.getName());
            if (valueDescriptor == null) {
                throw new NoSuchValueException(valueType.getName(), this.module.name());
            }
            Unqualified unqualified = (Unqualified)valueDescriptor.metaInfo(Unqualified.class);
            EntityComposite composite = (EntityComposite)entity;
            final EntityDescriptor entityDescriptor = this.spi.entityDescriptorFor((Object)composite);
            final AssociationStateHolder associationState = this.spi.stateOf(composite);
            ValueBuilder builder = unqualified == null || !unqualified.value() ? this.module.newValueBuilderWithState(valueType, (Function)new Function<PropertyDescriptor, Object>(){

                public Object map(PropertyDescriptor descriptor) {
                    try {
                        return associationState.propertyFor(descriptor.accessor()).get();
                    }
                    catch (IllegalArgumentException e) {
                        AssociationStateDescriptor entityState = entityDescriptor.state();
                        String associationName = descriptor.qualifiedName().name();
                        if (Shared.STRING_TYPE_SPEC.satisfiedBy((Object)descriptor.valueType())) {
                            AssociationDescriptor associationDescriptor;
                            try {
                                associationDescriptor = entityState.getAssociationByName(associationName);
                            }
                            catch (IllegalArgumentException e1) {
                                return null;
                            }
                            AccessibleObject associationMethod = associationDescriptor.accessor();
                            Object entity = associationState.associationFor(associationMethod).get();
                            if (entity != null) {
                                return ((Identity)entity).identity().get();
                            }
                            return null;
                        }
                        if (Shared.STRING_COLLECTION_TYPE_SPEC.satisfiedBy((Object)descriptor.valueType())) {
                            AssociationDescriptor associationDescriptor;
                            try {
                                associationDescriptor = entityState.getManyAssociationByName(associationName);
                            }
                            catch (IllegalArgumentException e1) {
                                return Collections.emptyList();
                            }
                            ManyAssociation state = associationState.manyAssociationFor(associationDescriptor.accessor());
                            ArrayList<Object> entities = new ArrayList<Object>(state.count());
                            for (Object entity : state) {
                                entities.add(((Identity)entity).identity().get());
                            }
                            return entities;
                        }
                        if (Shared.STRING_MAP_TYPE_SPEC.satisfiedBy((Object)descriptor.valueType())) {
                            AssociationDescriptor associationDescriptor;
                            try {
                                associationDescriptor = entityState.getNamedAssociationByName(associationName);
                            }
                            catch (IllegalArgumentException e1) {
                                return Collections.emptyMap();
                            }
                            NamedAssociation state = associationState.namedAssociationFor(associationDescriptor.accessor());
                            LinkedHashMap<String, Object> entities = new LinkedHashMap<String, Object>(state.count());
                            for (String name : state) {
                                entities.put(name, ((Identity)state.get(name)).identity().get());
                            }
                            return entities;
                        }
                        return null;
                    }
                }
            }, (Function)new Function<AssociationDescriptor, EntityReference>(){

                public EntityReference map(AssociationDescriptor associationDescriptor) {
                    return EntityReference.entityReferenceFor((Object)associationState.associationFor(associationDescriptor.accessor()).get());
                }
            }, (Function)new Function<AssociationDescriptor, Iterable<EntityReference>>(){

                public Iterable<EntityReference> map(AssociationDescriptor associationDescriptor) {
                    ManyAssociation state = associationState.manyAssociationFor(associationDescriptor.accessor());
                    ArrayList<EntityReference> refs = new ArrayList<EntityReference>(state.count());
                    for (Object entity : state) {
                        refs.add(EntityReference.entityReferenceFor(entity));
                    }
                    return refs;
                }
            }, (Function)new Function<AssociationDescriptor, Map<String, EntityReference>>(){

                public Map<String, EntityReference> map(AssociationDescriptor associationDescriptor) {
                    NamedAssociation assoc = associationState.namedAssociationFor(associationDescriptor.accessor());
                    LinkedHashMap<String, EntityReference> refs = new LinkedHashMap<String, EntityReference>(assoc.count());
                    for (String name : assoc) {
                        refs.put(name, EntityReference.entityReferenceFor((Object)assoc.get(name)));
                    }
                    return refs;
                }
            }) : this.module.newValueBuilderWithState(valueType, (Function)new Function<PropertyDescriptor, Object>(){

                public Object map(PropertyDescriptor descriptor) {
                    AssociationStateDescriptor entityState = entityDescriptor.state();
                    String propertyName = descriptor.qualifiedName().name();
                    try {
                        PropertyDescriptor propertyDescriptor = entityState.findPropertyModelByName(propertyName);
                        return associationState.propertyFor(propertyDescriptor.accessor()).get();
                    }
                    catch (IllegalArgumentException e) {
                        if (Shared.STRING_TYPE_SPEC.satisfiedBy((Object)descriptor.valueType())) {
                            AssociationDescriptor associationDescriptor;
                            try {
                                associationDescriptor = entityState.getAssociationByName(propertyName);
                            }
                            catch (IllegalArgumentException e1) {
                                return null;
                            }
                            AccessibleObject associationMethod = associationDescriptor.accessor();
                            Object entity = associationState.associationFor(associationMethod).get();
                            if (entity != null) {
                                return ((Identity)entity).identity().get();
                            }
                            return null;
                        }
                        if (Shared.STRING_COLLECTION_TYPE_SPEC.satisfiedBy((Object)descriptor.valueType())) {
                            AssociationDescriptor associationDescriptor;
                            try {
                                associationDescriptor = entityState.getManyAssociationByName(propertyName);
                            }
                            catch (IllegalArgumentException e1) {
                                return null;
                            }
                            AccessibleObject associationMethod = associationDescriptor.accessor();
                            ManyAssociation state = associationState.manyAssociationFor(associationMethod);
                            ArrayList<Object> entities = new ArrayList<Object>(state.count());
                            for (Object entity : state) {
                                entities.add(((Identity)entity).identity().get());
                            }
                            return entities;
                        }
                        if (Shared.STRING_MAP_TYPE_SPEC.satisfiedBy((Object)descriptor.valueType())) {
                            AssociationDescriptor associationDescriptor;
                            try {
                                associationDescriptor = entityState.getNamedAssociationByName(propertyName);
                            }
                            catch (IllegalArgumentException e1) {
                                return null;
                            }
                            AccessibleObject associationMethod = associationDescriptor.accessor();
                            NamedAssociation state = associationState.namedAssociationFor(associationMethod);
                            LinkedHashMap<String, Object> entities = new LinkedHashMap<String, Object>(state.count());
                            for (String name : state) {
                                entities.put(name, ((Identity)state.get(name)).identity().get());
                            }
                            return entities;
                        }
                        return null;
                    }
                }
            }, (Function)new Function<AssociationDescriptor, EntityReference>(){

                public EntityReference map(AssociationDescriptor descriptor) {
                    AssociationDescriptor associationDescriptor;
                    try {
                        associationDescriptor = entityDescriptor.state().getAssociationByName(descriptor.qualifiedName().name());
                    }
                    catch (IllegalArgumentException e) {
                        return null;
                    }
                    AccessibleObject associationMethod = associationDescriptor.accessor();
                    Association association = associationState.associationFor(associationMethod);
                    return EntityReference.entityReferenceFor((Object)association.get());
                }
            }, (Function)new Function<AssociationDescriptor, Iterable<EntityReference>>(){

                public Iterable<EntityReference> map(AssociationDescriptor descriptor) {
                    AssociationDescriptor associationDescriptor;
                    try {
                        String associationName = descriptor.qualifiedName().name();
                        AssociationStateDescriptor entityState = entityDescriptor.state();
                        associationDescriptor = entityState.getManyAssociationByName(associationName);
                    }
                    catch (IllegalArgumentException e) {
                        return Iterables.empty();
                    }
                    ManyAssociation state = associationState.manyAssociationFor(associationDescriptor.accessor());
                    ArrayList<EntityReference> refs = new ArrayList<EntityReference>(state.count());
                    for (Object entity : state) {
                        refs.add(EntityReference.entityReferenceFor(entity));
                    }
                    return refs;
                }
            }, (Function)new Function<AssociationDescriptor, Map<String, EntityReference>>(){

                public Map<String, EntityReference> map(AssociationDescriptor descriptor) {
                    AssociationDescriptor associationDescriptor;
                    try {
                        String associationName = descriptor.qualifiedName().name();
                        AssociationStateDescriptor entityState = entityDescriptor.state();
                        associationDescriptor = entityState.getNamedAssociationByName(associationName);
                    }
                    catch (IllegalArgumentException e) {
                        return Collections.emptyMap();
                    }
                    AccessibleObject associationMethod = associationDescriptor.accessor();
                    NamedAssociation assoc = associationState.namedAssociationFor(associationMethod);
                    LinkedHashMap<String, EntityReference> refs = new LinkedHashMap<String, EntityReference>(assoc.count());
                    for (String name : assoc) {
                        refs.put(name, EntityReference.entityReferenceFor((Object)assoc.get(name)));
                    }
                    return refs;
                }
            });
            return builder;
        }

        private <T> T createInstance(ValueBuilder<?> builder) {
            return (T)builder.newInstance();
        }
    }
}

