/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.conversion.values;

import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.association.AssociationStateDescriptor;
import org.qi4j.api.association.AssociationStateHolder;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.unitofwork.EntityTypeNotFoundException;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.api.value.ValueDescriptor;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.library.conversion.values.Shared;
import org.qi4j.library.conversion.values.Unqualified;
import org.qi4j.library.conversion.values.ValueToEntity;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.module.ModelModule;
import org.qi4j.spi.module.ModuleSpi;

public class ValueToEntityMixin
implements ValueToEntity {
    private static final QualifiedName IDENTITY_STATE_NAME;
    private static final Function<ManyAssociation<?>, Iterable<EntityReference>> MANY_ASSOC_TO_ENTITY_REF_ITERABLE;
    private static final Function<NamedAssociation<?>, Map<String, EntityReference>> NAMED_ASSOC_TO_ENTITY_REF_MAP;
    private static final Function<Collection<String>, Iterable<EntityReference>> STRING_COLLEC_TO_ENTITY_REF_ITERABLE;
    private static final Function<Map<String, String>, Map<String, EntityReference>> STRING_MAP_TO_ENTITY_REF_MAP;
    @Structure
    private Qi4jSPI spi;
    @Structure
    private ModuleSpi module;

    @Override
    public <T> T create(Class<T> entityType, Object value) {
        return this.createInstance(this.doConversion(entityType, null, value));
    }

    @Override
    public <T> T create(Class<T> entityType, String identity, Object value) {
        return this.createInstance(this.doConversion(entityType, identity, value));
    }

    @Override
    public <T> T create(Class<T> entityType, Object value, Function<T, T> prototypeOpportunity) {
        EntityBuilder<?> builder = this.doConversion(entityType, null, value);
        prototypeOpportunity.map(builder.instance());
        return this.createInstance(builder);
    }

    @Override
    public <T> T create(Class<T> entityType, String identity, Object value, Function<T, T> prototypeOpportunity) {
        EntityBuilder<?> builder = this.doConversion(entityType, identity, value);
        prototypeOpportunity.map(builder.instance());
        return this.createInstance(builder);
    }

    @Override
    public <T> Iterable<T> create(final Class<T> entityType, Iterable<Object> values) {
        return Iterables.map((Function)new Function<Object, T>(){

            public T map(Object value) {
                return ValueToEntityMixin.this.create(entityType, value);
            }
        }, values);
    }

    @Override
    public <T> Iterable<T> create(final Class<T> entityType, Iterable<Object> values, final Function<T, T> prototypeOpportunity) {
        return Iterables.map((Function)new Function<Object, T>(){

            public T map(Object value) {
                return ValueToEntityMixin.this.create(entityType, value, prototypeOpportunity);
            }
        }, values);
    }

    private <T> EntityBuilder<?> doConversion(Class<T> entityType, String identity, Object value) {
        EntityDescriptor eDesc = this.module.entityDescriptor(entityType.getName());
        if (eDesc == null) {
            throw new EntityTypeNotFoundException(entityType.getName(), this.module.name(), Iterables.map((Function)ModelModule.toStringFunction, (Iterable)this.module.findVisibleEntityTypes()));
        }
        ValueComposite vComposite = (ValueComposite)value;
        ValueDescriptor vDesc = this.spi.valueDescriptorFor((Object)vComposite);
        AssociationStateHolder vState = this.spi.stateOf(vComposite);
        AssociationStateDescriptor vStateDesc = vDesc.state();
        Unqualified unqualified = (Unqualified)vDesc.metaInfo(Unqualified.class);
        if (unqualified == null || !unqualified.value()) {
            return this.doQualifiedConversion(entityType, identity, vState, vStateDesc);
        }
        return this.doUnqualifiedConversion(entityType, identity, vState, vStateDesc);
    }

    private <T> EntityBuilder<?> doQualifiedConversion(Class<T> entityType, String identity, final AssociationStateHolder vState, final AssociationStateDescriptor vStateDesc) {
        Function<PropertyDescriptor, Object> props = new Function<PropertyDescriptor, Object>(){

            public Object map(PropertyDescriptor ePropDesc) {
                try {
                    return vState.propertyFor(ePropDesc.accessor()).get();
                }
                catch (IllegalArgumentException propNotFoundOnValue) {
                    return null;
                }
            }
        };
        Function<AssociationDescriptor, EntityReference> assocs = new Function<AssociationDescriptor, EntityReference>(){

            public EntityReference map(AssociationDescriptor eAssocDesc) {
                try {
                    return EntityReference.entityReferenceFor((Object)vState.associationFor(eAssocDesc.accessor()));
                }
                catch (IllegalArgumentException assocNotFoundOnValue) {
                    String propName = eAssocDesc.qualifiedName().name();
                    try {
                        PropertyDescriptor vPropDesc = vStateDesc.findPropertyModelByName(propName);
                        if (Shared.STRING_TYPE_SPEC.satisfiedBy((Object)vPropDesc.valueType())) {
                            String assocState = (String)vState.propertyFor(vPropDesc.accessor()).get();
                            return EntityReference.parseEntityReference((String)assocState);
                        }
                        return null;
                    }
                    catch (IllegalArgumentException propNotFoundOnValue) {
                        return null;
                    }
                }
            }
        };
        Function<AssociationDescriptor, Iterable<EntityReference>> manyAssocs = new Function<AssociationDescriptor, Iterable<EntityReference>>(){

            public Iterable<EntityReference> map(AssociationDescriptor eAssocDesc) {
                try {
                    ManyAssociation vAssocState = vState.manyAssociationFor(eAssocDesc.accessor());
                    return (Iterable)MANY_ASSOC_TO_ENTITY_REF_ITERABLE.map((Object)vAssocState);
                }
                catch (IllegalArgumentException assocNotFoundOnValue) {
                    String propName = eAssocDesc.qualifiedName().name();
                    try {
                        PropertyDescriptor vPropDesc = vStateDesc.findPropertyModelByName(propName);
                        if (Shared.STRING_COLLECTION_TYPE_SPEC.satisfiedBy((Object)vPropDesc.valueType())) {
                            Collection vAssocState = (Collection)vState.propertyFor(vPropDesc.accessor()).get();
                            return (Iterable)STRING_COLLEC_TO_ENTITY_REF_ITERABLE.map((Object)vAssocState);
                        }
                        return Iterables.empty();
                    }
                    catch (IllegalArgumentException propNotFoundOnValue) {
                        return Iterables.empty();
                    }
                }
            }
        };
        Function<AssociationDescriptor, Map<String, EntityReference>> namedAssocs = new Function<AssociationDescriptor, Map<String, EntityReference>>(){

            public Map<String, EntityReference> map(AssociationDescriptor eAssocDesc) {
                try {
                    NamedAssociation vAssocState = vState.namedAssociationFor(eAssocDesc.accessor());
                    return (Map)NAMED_ASSOC_TO_ENTITY_REF_MAP.map((Object)vAssocState);
                }
                catch (IllegalArgumentException assocNotFoundOnValue) {
                    String propName = eAssocDesc.qualifiedName().name();
                    try {
                        PropertyDescriptor vPropDesc = vStateDesc.findPropertyModelByName(propName);
                        if (Shared.STRING_MAP_TYPE_SPEC.satisfiedBy((Object)vPropDesc.valueType())) {
                            Map vAssocState = (Map)vState.propertyFor(vPropDesc.accessor()).get();
                            return (Map)STRING_MAP_TO_ENTITY_REF_MAP.map((Object)vAssocState);
                        }
                        return Collections.EMPTY_MAP;
                    }
                    catch (IllegalArgumentException propNotFoundOnValue) {
                        return Collections.EMPTY_MAP;
                    }
                }
            }
        };
        return this.module.currentUnitOfWork().newEntityBuilderWithState(entityType, identity, (Function)props, (Function)assocs, (Function)manyAssocs, (Function)namedAssocs);
    }

    private <T> EntityBuilder<?> doUnqualifiedConversion(Class<T> entityType, String identity, final AssociationStateHolder vState, final AssociationStateDescriptor vStateDesc) {
        Function<PropertyDescriptor, Object> props = new Function<PropertyDescriptor, Object>(){

            public Object map(PropertyDescriptor ePropDesc) {
                String propName = ePropDesc.qualifiedName().name();
                try {
                    PropertyDescriptor vPropDesc = vStateDesc.findPropertyModelByName(propName);
                    return vState.propertyFor(vPropDesc.accessor()).get();
                }
                catch (IllegalArgumentException propNotFoundOnValue) {
                    return null;
                }
            }
        };
        Function<AssociationDescriptor, EntityReference> assocs = new Function<AssociationDescriptor, EntityReference>(){

            public EntityReference map(AssociationDescriptor eAssocDesc) {
                String assocName = eAssocDesc.qualifiedName().name();
                try {
                    AssociationDescriptor vAssocDesc = vStateDesc.getAssociationByName(assocName);
                    Object assocEntity = vState.associationFor(vAssocDesc.accessor()).get();
                    return assocEntity == null ? null : EntityReference.entityReferenceFor((Object)assocEntity);
                }
                catch (IllegalArgumentException assocNotFoundOnValue) {
                    try {
                        PropertyDescriptor vPropDesc = vStateDesc.findPropertyModelByName(assocName);
                        if (Shared.STRING_TYPE_SPEC.satisfiedBy((Object)vPropDesc.valueType())) {
                            String assocId = (String)vState.propertyFor(vPropDesc.accessor()).get();
                            return assocId == null ? null : EntityReference.parseEntityReference((String)assocId);
                        }
                        return null;
                    }
                    catch (IllegalArgumentException propNotFoundOnValue) {
                        return null;
                    }
                }
            }
        };
        Function<AssociationDescriptor, Iterable<EntityReference>> manyAssocs = new Function<AssociationDescriptor, Iterable<EntityReference>>(){

            public Iterable<EntityReference> map(AssociationDescriptor eAssocDesc) {
                String assocName = eAssocDesc.qualifiedName().name();
                try {
                    AssociationDescriptor vAssocDesc = vStateDesc.getManyAssociationByName(assocName);
                    ManyAssociation vManyAssoc = vState.manyAssociationFor(vAssocDesc.accessor());
                    return (Iterable)MANY_ASSOC_TO_ENTITY_REF_ITERABLE.map((Object)vManyAssoc);
                }
                catch (IllegalArgumentException assocNotFoundOnValue) {
                    try {
                        PropertyDescriptor vPropDesc = vStateDesc.findPropertyModelByName(assocName);
                        if (Shared.STRING_COLLECTION_TYPE_SPEC.satisfiedBy((Object)vPropDesc.valueType())) {
                            Collection vAssocState = (Collection)vState.propertyFor(vPropDesc.accessor()).get();
                            return (Iterable)STRING_COLLEC_TO_ENTITY_REF_ITERABLE.map((Object)vAssocState);
                        }
                        return Iterables.empty();
                    }
                    catch (IllegalArgumentException propNotFoundOnValue) {
                        return Iterables.empty();
                    }
                }
            }
        };
        Function<AssociationDescriptor, Map<String, EntityReference>> namedAssocs = new Function<AssociationDescriptor, Map<String, EntityReference>>(){

            public Map<String, EntityReference> map(AssociationDescriptor eAssocDesc) {
                String assocName = eAssocDesc.qualifiedName().name();
                try {
                    AssociationDescriptor vAssocDesc = vStateDesc.getNamedAssociationByName(assocName);
                    NamedAssociation vAssocState = vState.namedAssociationFor(vAssocDesc.accessor());
                    return (Map)NAMED_ASSOC_TO_ENTITY_REF_MAP.map((Object)vAssocState);
                }
                catch (IllegalArgumentException assocNotFoundOnValue) {
                    try {
                        PropertyDescriptor vPropDesc = vStateDesc.findPropertyModelByName(assocName);
                        if (Shared.STRING_MAP_TYPE_SPEC.satisfiedBy((Object)vPropDesc.valueType())) {
                            Map vAssocState = (Map)vState.propertyFor(vPropDesc.accessor()).get();
                            return (Map)STRING_MAP_TO_ENTITY_REF_MAP.map((Object)vAssocState);
                        }
                        return Collections.EMPTY_MAP;
                    }
                    catch (IllegalArgumentException propNotFoundOnValue) {
                        return Collections.EMPTY_MAP;
                    }
                }
            }
        };
        return this.module.currentUnitOfWork().newEntityBuilderWithState(entityType, identity, (Function)props, (Function)assocs, (Function)manyAssocs, (Function)namedAssocs);
    }

    protected <T> T createInstance(EntityBuilder<?> builder) {
        return (T)builder.newInstance();
    }

    @Override
    public void update(Object entity, Object value) throws NoSuchEntityException {
        EntityComposite eComposite = (EntityComposite)entity;
        ValueComposite vComposite = (ValueComposite)value;
        EntityDescriptor eDesc = this.spi.entityDescriptorFor((Object)eComposite);
        AssociationStateHolder eState = this.spi.stateOf(eComposite);
        AssociationStateDescriptor eStateDesc = eDesc.state();
        ValueDescriptor vDesc = this.spi.valueDescriptorFor((Object)vComposite);
        AssociationStateHolder vState = this.spi.stateOf(vComposite);
        AssociationStateDescriptor vStateDesc = vDesc.state();
        Unqualified unqualified = (Unqualified)vDesc.metaInfo(Unqualified.class);
        if (unqualified == null || !unqualified.value()) {
            this.doQualifiedUpdate(eState, eStateDesc, vState, vStateDesc);
        } else {
            this.doUnQualifiedUpdate(eState, eStateDesc, vState, vStateDesc);
        }
    }

    private void doQualifiedUpdate(AssociationStateHolder eState, AssociationStateDescriptor eStateDesc, AssociationStateHolder vState, AssociationStateDescriptor vStateDesc) throws NoSuchEntityException {
        Object vAssocState;
        PropertyDescriptor vPropDesc;
        AssociationDescriptor vAssocDesc;
        for (PropertyDescriptor ePropDesc : eStateDesc.properties()) {
            if (IDENTITY_STATE_NAME.equals((Object)ePropDesc.qualifiedName())) continue;
            try {
                PropertyDescriptor vPropDesc2 = vStateDesc.findPropertyModelByQualifiedName(ePropDesc.qualifiedName());
                eState.propertyFor(ePropDesc.accessor()).set(vState.propertyFor(vPropDesc2.accessor()).get());
            }
            catch (IllegalArgumentException propNotFoundOnValue) {}
        }
        for (AssociationDescriptor eAssocDesc : eStateDesc.associations()) {
            Association eAssoc = eState.associationFor(eAssocDesc.accessor());
            try {
                vAssocDesc = vStateDesc.getAssociationByQualifiedName(eAssocDesc.qualifiedName());
                eAssoc.set(vState.associationFor(vAssocDesc.accessor()).get());
            }
            catch (IllegalArgumentException assocNotFoundOnValue) {
                try {
                    vPropDesc = vStateDesc.findPropertyModelByName(eAssocDesc.qualifiedName().name());
                    if (!Shared.STRING_TYPE_SPEC.satisfiedBy((Object)vPropDesc.valueType())) continue;
                    String assocId = (String)vState.propertyFor(vPropDesc.accessor()).get();
                    if (assocId != null) {
                        eAssoc.set(this.module.currentUnitOfWork().get((Class)eAssocDesc.type(), assocId));
                        continue;
                    }
                    eAssoc.set(null);
                }
                catch (IllegalArgumentException propNotFoundOnValue) {}
            }
        }
        for (AssociationDescriptor eAssocDesc : eStateDesc.manyAssociations()) {
            ManyAssociation eManyAssoc = eState.manyAssociationFor(eAssocDesc.accessor());
            try {
                vAssocDesc = vStateDesc.getManyAssociationByQualifiedName(eAssocDesc.qualifiedName());
                ManyAssociation vManyAssoc = vState.manyAssociationFor(vAssocDesc.accessor());
                for (Object e : eManyAssoc.toList()) {
                    eManyAssoc.remove(e);
                }
                for (Object e : vManyAssoc.toList()) {
                    eManyAssoc.add(e);
                }
            }
            catch (IllegalArgumentException assocNotFoundOnValue) {
                try {
                    vPropDesc = vStateDesc.findPropertyModelByName(eAssocDesc.qualifiedName().name());
                    if (!Shared.STRING_COLLECTION_TYPE_SPEC.satisfiedBy((Object)vPropDesc.valueType())) continue;
                    vAssocState = (Collection)vState.propertyFor(vPropDesc.accessor()).get();
                    for (Object e : eManyAssoc.toList()) {
                        eManyAssoc.remove(e);
                    }
                    if (vAssocState == null) continue;
                    Iterator iterator = vAssocState.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        eManyAssoc.add(this.module.currentUnitOfWork().get((Class)eAssocDesc.type(), string));
                    }
                }
                catch (IllegalArgumentException propNotFoundOnValue) {
                }
            }
        }
        for (AssociationDescriptor eAssocDesc : eStateDesc.namedAssociations()) {
            NamedAssociation eNamedAssoc = eState.namedAssociationFor(eAssocDesc.accessor());
            try {
                vAssocDesc = vStateDesc.getNamedAssociationByQualifiedName(eAssocDesc.qualifiedName());
                NamedAssociation vNamedAssoc = vState.namedAssociationFor(vAssocDesc.accessor());
                for (String string : Iterables.toList((Iterable)eNamedAssoc)) {
                    eNamedAssoc.remove(string);
                }
                for (Map.Entry entry : vNamedAssoc.toMap().entrySet()) {
                    eNamedAssoc.put((String)entry.getKey(), entry.getValue());
                }
            }
            catch (IllegalArgumentException assocNotFoundOnValue) {
                try {
                    vPropDesc = vStateDesc.findPropertyModelByName(eAssocDesc.qualifiedName().name());
                    if (!Shared.STRING_MAP_TYPE_SPEC.satisfiedBy((Object)vPropDesc.valueType())) continue;
                    vAssocState = (Map)vState.propertyFor(vPropDesc.accessor()).get();
                    for (String string : Iterables.toList((Iterable)eNamedAssoc)) {
                        eNamedAssoc.remove(string);
                    }
                    if (vAssocState == null) continue;
                    for (Map.Entry entry : vAssocState.entrySet()) {
                        eNamedAssoc.put((String)entry.getKey(), this.module.currentUnitOfWork().get((Class)eAssocDesc.type(), (String)entry.getValue()));
                    }
                }
                catch (IllegalArgumentException propNotFoundOnValue) {
                }
            }
        }
    }

    private void doUnQualifiedUpdate(AssociationStateHolder eState, AssociationStateDescriptor eStateDesc, AssociationStateHolder vState, AssociationStateDescriptor vStateDesc) {
        Object vAssocState;
        PropertyDescriptor vPropDesc;
        AssociationDescriptor vAssocDesc;
        for (PropertyDescriptor ePropDesc : eStateDesc.properties()) {
            if (IDENTITY_STATE_NAME.equals((Object)ePropDesc.qualifiedName())) continue;
            try {
                PropertyDescriptor vPropDesc2 = vStateDesc.findPropertyModelByName(ePropDesc.qualifiedName().name());
                eState.propertyFor(ePropDesc.accessor()).set(vState.propertyFor(vPropDesc2.accessor()).get());
            }
            catch (IllegalArgumentException propNotFoundOnValue) {}
        }
        for (AssociationDescriptor eAssocDesc : eStateDesc.associations()) {
            Association eAssoc = eState.associationFor(eAssocDesc.accessor());
            try {
                vAssocDesc = vStateDesc.getAssociationByName(eAssocDesc.qualifiedName().name());
                eAssoc.set(vState.associationFor(vAssocDesc.accessor()).get());
            }
            catch (IllegalArgumentException assocNotFoundOnValue) {
                try {
                    vPropDesc = vStateDesc.findPropertyModelByName(eAssocDesc.qualifiedName().name());
                    if (!Shared.STRING_TYPE_SPEC.satisfiedBy((Object)vPropDesc.valueType())) continue;
                    String assocId = (String)vState.propertyFor(vPropDesc.accessor()).get();
                    if (assocId != null) {
                        eAssoc.set(this.module.currentUnitOfWork().get((Class)eAssocDesc.type(), assocId));
                        continue;
                    }
                    eAssoc.set(null);
                }
                catch (IllegalArgumentException propNotFoundOnValue) {}
            }
        }
        for (AssociationDescriptor eAssocDesc : eStateDesc.manyAssociations()) {
            ManyAssociation eManyAssoc = eState.manyAssociationFor(eAssocDesc.accessor());
            try {
                AssociationDescriptor vAssDesc = vStateDesc.getManyAssociationByName(eAssocDesc.qualifiedName().name());
                ManyAssociation vManyAss = vState.manyAssociationFor(vAssDesc.accessor());
                for (Object e : eManyAssoc.toList()) {
                    eManyAssoc.remove(e);
                }
                for (Object e : vManyAss.toList()) {
                    eManyAssoc.add(e);
                }
            }
            catch (IllegalArgumentException assNotFoundOnValue) {
                try {
                    vPropDesc = vStateDesc.findPropertyModelByName(eAssocDesc.qualifiedName().name());
                    if (!Shared.STRING_COLLECTION_TYPE_SPEC.satisfiedBy((Object)vPropDesc.valueType())) continue;
                    vAssocState = (Collection)vState.propertyFor(vPropDesc.accessor()).get();
                    for (Object e : eManyAssoc.toList()) {
                        eManyAssoc.remove(e);
                    }
                    if (vAssocState == null) continue;
                    Iterator iterator = vAssocState.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        eManyAssoc.add(this.module.currentUnitOfWork().get((Class)eAssocDesc.type(), string));
                    }
                }
                catch (IllegalArgumentException propNotFoundOnValue) {
                }
            }
        }
        for (AssociationDescriptor eAssocDesc : eStateDesc.namedAssociations()) {
            NamedAssociation eNamedAssoc = eState.namedAssociationFor(eAssocDesc.accessor());
            try {
                vAssocDesc = vStateDesc.getNamedAssociationByName(eAssocDesc.qualifiedName().name());
                NamedAssociation vNamedAssoc = vState.namedAssociationFor(vAssocDesc.accessor());
                for (String string : Iterables.toList((Iterable)eNamedAssoc)) {
                    eNamedAssoc.remove(string);
                }
                for (Map.Entry entry : vNamedAssoc.toMap().entrySet()) {
                    eNamedAssoc.put((String)entry.getKey(), entry.getValue());
                }
            }
            catch (IllegalArgumentException assocNotFoundOnValue) {
                try {
                    vPropDesc = vStateDesc.findPropertyModelByName(eAssocDesc.qualifiedName().name());
                    if (!Shared.STRING_MAP_TYPE_SPEC.satisfiedBy((Object)vPropDesc.valueType())) continue;
                    vAssocState = (Map)vState.propertyFor(vPropDesc.accessor()).get();
                    for (String string : Iterables.toList((Iterable)eNamedAssoc)) {
                        eNamedAssoc.remove(string);
                    }
                    if (vAssocState == null) continue;
                    for (Map.Entry entry : vAssocState.entrySet()) {
                        eNamedAssoc.put((String)entry.getKey(), this.module.currentUnitOfWork().get((Class)eAssocDesc.type(), (String)entry.getValue()));
                    }
                }
                catch (IllegalArgumentException propNotFoundOnValue) {
                }
            }
        }
    }

    static {
        try {
            IDENTITY_STATE_NAME = QualifiedName.fromAccessor((AccessibleObject)Identity.class.getMethod("identity", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("Zest Core Runtime codebase is corrupted. Contact Zest team: ValueToEntityMixin");
        }
        MANY_ASSOC_TO_ENTITY_REF_ITERABLE = new Function<ManyAssociation<?>, Iterable<EntityReference>>(){

            public Iterable<EntityReference> map(ManyAssociation<?> manyAssoc) {
                if (manyAssoc == null) {
                    return Iterables.empty();
                }
                ArrayList<EntityReference> refs = new ArrayList<EntityReference>(manyAssoc.count());
                for (Object entity : manyAssoc) {
                    refs.add(EntityReference.entityReferenceFor(entity));
                }
                return refs;
            }
        };
        NAMED_ASSOC_TO_ENTITY_REF_MAP = new Function<NamedAssociation<?>, Map<String, EntityReference>>(){

            public Map<String, EntityReference> map(NamedAssociation<?> namedAssoc) {
                if (namedAssoc == null) {
                    return Collections.emptyMap();
                }
                LinkedHashMap<String, EntityReference> refs = new LinkedHashMap<String, EntityReference>(namedAssoc.count());
                for (String name : namedAssoc) {
                    refs.put(name, EntityReference.entityReferenceFor((Object)namedAssoc.get(name)));
                }
                return refs;
            }
        };
        STRING_COLLEC_TO_ENTITY_REF_ITERABLE = new Function<Collection<String>, Iterable<EntityReference>>(){

            public Iterable<EntityReference> map(Collection<String> stringCollec) {
                if (stringCollec == null) {
                    return Iterables.empty();
                }
                ArrayList<EntityReference> refList = new ArrayList<EntityReference>();
                for (String assId : stringCollec) {
                    refList.add(EntityReference.parseEntityReference((String)assId));
                }
                return refList;
            }
        };
        STRING_MAP_TO_ENTITY_REF_MAP = new Function<Map<String, String>, Map<String, EntityReference>>(){

            public Map<String, EntityReference> map(Map<String, String> stringMap) {
                if (stringMap == null) {
                    return Collections.emptyMap();
                }
                LinkedHashMap<String, EntityReference> refMap = new LinkedHashMap<String, EntityReference>(stringMap.size());
                for (Map.Entry<String, String> entry : stringMap.entrySet()) {
                    refMap.put(entry.getKey(), EntityReference.parseEntityReference((String)entry.getValue()));
                }
                return refMap;
            }
        };
    }
}

