/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rdf.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.XMLSchema;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.util.Classes;
import org.qi4j.functional.Iterables;
import org.qi4j.library.rdf.Qi4jEntityType;
import org.qi4j.library.rdf.Rdfs;

public class EntityTypeSerializer {
    private final Map<String, URI> dataTypes = new HashMap<String, URI>(12);

    public EntityTypeSerializer() {
        this.dataTypes.put(String.class.getName(), XMLSchema.STRING);
        this.dataTypes.put(Integer.class.getName(), XMLSchema.INT);
        this.dataTypes.put(Boolean.class.getName(), XMLSchema.BOOLEAN);
        this.dataTypes.put(Byte.class.getName(), XMLSchema.BYTE);
        this.dataTypes.put(BigDecimal.class.getName(), XMLSchema.DECIMAL);
        this.dataTypes.put(Double.class.getName(), XMLSchema.DOUBLE);
        this.dataTypes.put(Long.class.getName(), XMLSchema.LONG);
        this.dataTypes.put(Short.class.getName(), XMLSchema.SHORT);
        this.dataTypes.put(Date.class.getName(), XMLSchema.DATETIME);
        this.dataTypes.put(DateTime.class.getName(), XMLSchema.DATETIME);
        this.dataTypes.put(LocalDateTime.class.getName(), XMLSchema.DATETIME);
        this.dataTypes.put(LocalDate.class.getName(), XMLSchema.DATE);
    }

    public Iterable<Statement> serialize(EntityDescriptor entityDescriptor) {
        GraphImpl graph = new GraphImpl();
        ValueFactory values = graph.getValueFactory();
        URI entityTypeUri = values.createURI(Classes.toURI((Class)((Class)Iterables.first((Iterable)entityDescriptor.types()))));
        graph.add((Resource)entityTypeUri, Rdfs.TYPE, (Value)Rdfs.CLASS, new Resource[0]);
        graph.add((Resource)entityTypeUri, Rdfs.TYPE, (Value)OWL.CLASS, new Resource[0]);
        graph.add((Resource)entityTypeUri, Qi4jEntityType.TYPE, (Value)values.createLiteral(((Class)Iterables.first((Iterable)entityDescriptor.types())).toString()), new Resource[0]);
        graph.add((Resource)entityTypeUri, Qi4jEntityType.QUERYABLE, (Value)values.createLiteral(entityDescriptor.queryable()), new Resource[0]);
        this.serializeMixinTypes(entityDescriptor, (Graph)graph, entityTypeUri);
        this.serializePropertyTypes(entityDescriptor, (Graph)graph, entityTypeUri);
        this.serializeAssociationTypes(entityDescriptor, (Graph)graph, entityTypeUri);
        this.serializeManyAssociationTypes(entityDescriptor, (Graph)graph, entityTypeUri);
        return graph;
    }

    private void serializeMixinTypes(EntityDescriptor entityDescriptor, Graph graph, URI entityTypeUri) {
        ValueFactory values = graph.getValueFactory();
        for (Class mixinType : entityDescriptor.mixinTypes()) {
            graph.add((Resource)entityTypeUri, Rdfs.SUB_CLASS_OF, (Value)values.createURI(Classes.toURI((Class)mixinType)), new Resource[0]);
        }
    }

    private void serializeManyAssociationTypes(EntityDescriptor entityDescriptor, Graph graph, URI entityTypeUri) {
        ValueFactory values = graph.getValueFactory();
        for (AssociationDescriptor manyAssociationType : entityDescriptor.state().manyAssociations()) {
            URI associationURI = values.createURI(manyAssociationType.qualifiedName().toURI());
            graph.add((Resource)associationURI, Rdfs.DOMAIN, (Value)entityTypeUri, new Resource[0]);
            graph.add((Resource)associationURI, Rdfs.TYPE, (Value)Rdfs.SEQ, new Resource[0]);
            URI associatedURI = values.createURI(manyAssociationType.qualifiedName().toURI());
            graph.add((Resource)associationURI, Rdfs.RANGE, (Value)associatedURI, new Resource[0]);
            graph.add((Resource)associationURI, Rdfs.RANGE, (Value)XMLSchema.ANYURI, new Resource[0]);
        }
    }

    private void serializeAssociationTypes(EntityDescriptor entityDescriptor, Graph graph, URI entityTypeUri) {
        ValueFactory values = graph.getValueFactory();
        for (AssociationDescriptor associationType : entityDescriptor.state().associations()) {
            URI associationURI = values.createURI(associationType.qualifiedName().toURI());
            graph.add((Resource)associationURI, Rdfs.DOMAIN, (Value)entityTypeUri, new Resource[0]);
            graph.add((Resource)associationURI, Rdfs.TYPE, (Value)Rdfs.PROPERTY, new Resource[0]);
            URI associatedURI = values.createURI(Classes.toURI((Class)((Class)Classes.RAW_CLASS.map((Object)associationType.type()))));
            graph.add((Resource)associationURI, Rdfs.RANGE, (Value)associatedURI, new Resource[0]);
            graph.add((Resource)associationURI, Rdfs.RANGE, (Value)XMLSchema.ANYURI, new Resource[0]);
        }
    }

    private void serializePropertyTypes(EntityDescriptor entityDescriptor, Graph graph, URI entityTypeUri) {
        ValueFactory values = graph.getValueFactory();
        for (PropertyDescriptor persistentProperty : entityDescriptor.state().properties()) {
            URI propertyURI = values.createURI(persistentProperty.qualifiedName().toURI());
            graph.add((Resource)propertyURI, Rdfs.DOMAIN, (Value)entityTypeUri, new Resource[0]);
            graph.add((Resource)propertyURI, Rdfs.TYPE, (Value)Rdfs.PROPERTY, new Resource[0]);
            URI type = this.dataTypes.get(persistentProperty.valueType().mainType().getName());
            if (type == null) continue;
            graph.add((Resource)propertyURI, Rdfs.RANGE, (Value)type, new Resource[0]);
        }
    }
}

