/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rdf.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.qi4j.api.composite.DependencyDescriptor;
import org.qi4j.api.composite.MethodDescriptor;
import org.qi4j.api.composite.TransientDescriptor;
import org.qi4j.api.mixin.MixinDescriptor;
import org.qi4j.api.structure.ApplicationDescriptor;
import org.qi4j.api.structure.LayerDescriptor;
import org.qi4j.api.structure.ModuleDescriptor;
import org.qi4j.functional.Function;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.Iterables;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Model2XML
implements Function<ApplicationDescriptor, Document> {
    private static Map<String, String> simpleMappings = new HashMap<String, String>();

    public Document map(ApplicationDescriptor Application2) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            final Document document = builder.newDocument();
            final Stack<Document> current = new Stack<Document>();
            current.push(document);
            Application2.accept((HierarchicalVisitor)new HierarchicalVisitor<Object, Object, DOMException>(){

                public boolean visitEnter(Object visited) throws DOMException {
                    String mapping = (String)simpleMappings.get(visited.getClass().getSimpleName());
                    if (mapping != null) {
                        Element node = document.createElement("mapping");
                        current.push(node);
                    } else if (visited instanceof ApplicationDescriptor) {
                        ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)visited;
                        Element application = document.createElement("application");
                        this.addAttribute("name", applicationDescriptor.name(), application);
                        current.push(application);
                    } else if (visited instanceof LayerDescriptor) {
                        LayerDescriptor layerDescriptor = (LayerDescriptor)visited;
                        Element layer = document.createElement("layer");
                        this.addAttribute("name", layerDescriptor.name(), layer);
                        current.push(layer);
                    } else if (visited instanceof ModuleDescriptor) {
                        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)visited;
                        Element module = document.createElement("module");
                        this.addAttribute("name", moduleDescriptor.name(), module);
                        current.push(module);
                    } else if (visited instanceof TransientDescriptor) {
                        TransientDescriptor descriptor = (TransientDescriptor)visited;
                        Element node = document.createElement("transient");
                        this.addAttribute("type", ((Class)Iterables.first((Iterable)descriptor.types())).getName(), node);
                        this.addAttribute("visibility", descriptor.visibility().name(), node);
                        current.push(node);
                    } else if (visited instanceof MethodDescriptor) {
                        MethodDescriptor descriptor = (MethodDescriptor)visited;
                        Element node = document.createElement("method");
                        this.addAttribute("name", descriptor.method().getName(), node);
                        current.push(node);
                    } else if (visited instanceof MixinDescriptor) {
                        MixinDescriptor descriptor = (MixinDescriptor)visited;
                        Element node = document.createElement("mixin");
                        this.addAttribute("class", descriptor.mixinClass().getName(), node);
                        current.push(node);
                    } else if (visited instanceof DependencyDescriptor) {
                        DependencyDescriptor descriptor = (DependencyDescriptor)visited;
                        Element node = document.createElement("dependency");
                        this.addAttribute("annotation", descriptor.injectionAnnotation().toString(), node);
                        this.addAttribute("injection", descriptor.injectionType().toString(), node);
                        this.addAttribute("optional", Boolean.toString(descriptor.optional()), node);
                        current.push(node);
                    } else {
                        Element element = document.createElement(visited.getClass().getSimpleName());
                        current.push(element);
                    }
                    return true;
                }

                public boolean visitLeave(Object visited) throws DOMException {
                    Node node = (Node)current.pop();
                    if (node.getChildNodes().getLength() == 0 && node.getAttributes().getLength() == 0) {
                        return true;
                    }
                    ((Node)current.peek()).appendChild(node);
                    return true;
                }

                public boolean visit(Object visited) throws DOMException {
                    Element element;
                    if (visited instanceof DependencyDescriptor) {
                        DependencyDescriptor descriptor = (DependencyDescriptor)visited;
                        element = document.createElement("dependency");
                        this.addAttribute("annotation", descriptor.injectionAnnotation().toString(), element);
                        this.addAttribute("injection", descriptor.injectionType().toString(), element);
                        this.addAttribute("optional", Boolean.toString(descriptor.optional()), element);
                    } else {
                        element = document.createElement(visited.getClass().getSimpleName());
                    }
                    ((Node)current.peek()).appendChild(element);
                    return true;
                }

                private void addAttribute(String name, String value, Node node) {
                    Attr attr = document.createAttribute(name);
                    attr.setValue(value);
                    ((Element)node).setAttributeNode(attr);
                }
            });
            return document;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    static {
        simpleMappings.put("TransientsModel", "transients");
        simpleMappings.put("EntitiesModel", "entities");
        simpleMappings.put("ServicesModel", "services");
        simpleMappings.put("ImportedServicesModel", "importedservices");
        simpleMappings.put("ObjectsModel", "objects");
        simpleMappings.put("ValuesModel", "values");
        simpleMappings.put("MixinsModel", "mixins");
        simpleMappings.put("CompositeMethodsModel", "methods");
        simpleMappings.put("InjectedFieldsModel", "injectedfields");
        simpleMappings.put("InjectedFieldModel", "injectedfield");
    }
}

