/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rdf.repository;

import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPRepository;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.Property;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.library.rdf.repository.HttpRepositoryConfiguration;

@Mixins(value={HttpRepositoryMixin.class})
@Activators(value={Activator.class})
public interface HttpRepositoryService
extends Repository,
ServiceComposite {
    public void initialize() throws RepositoryException;

    public void shutDown() throws RepositoryException;

    public static class HttpRepositoryMixin
    extends HTTPRepository
    implements Repository {
        public HttpRepositoryMixin(@This Configuration<HttpRepositoryConfiguration> configuration) {
            super(HttpRepositoryMixin.getRepositoryUrl((HttpRepositoryConfiguration)configuration.get()), HttpRepositoryMixin.getRepositoryId((HttpRepositoryConfiguration)configuration.get()));
        }

        private static String getRepositoryUrl(HttpRepositoryConfiguration configuration) {
            Property<String> repositoryUrl = configuration.repositoryUrl();
            String url = (String)repositoryUrl.get();
            if (url == null) {
                url = "http://localhost:8183/";
                repositoryUrl.set((Object)url);
            }
            return url;
        }

        private static String getRepositoryId(HttpRepositoryConfiguration configuration) {
            Property<String> id = configuration.repositoryId();
            if (id.get() == null) {
                id.set((Object)"qi4j");
            }
            return (String)id.get();
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<HttpRepositoryService>> {
        public void afterActivation(ServiceReference<HttpRepositoryService> activated) throws Exception {
            ((HttpRepositoryService)activated.get()).initialize();
        }

        public void beforePassivation(ServiceReference<HttpRepositoryService> passivating) throws Exception {
            ((HttpRepositoryService)passivating.get()).shutDown();
        }
    }
}

