/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rdf.serializer;

import java.io.Writer;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.qi4j.library.rdf.serializer.Serializer;

abstract class AbstractSerializer
implements Serializer {
    private Class<? extends RDFWriterFactory> writerFactoryClass;

    protected AbstractSerializer(Class<? extends RDFWriterFactory> writerFactoryClass) {
        this.writerFactoryClass = writerFactoryClass;
    }

    @Override
    public void serialize(Iterable<Statement> graph, Writer out) throws RDFHandlerException {
        String[] prefixes = new String[]{"qi4j", "rdf", "rdfs"};
        String[] namespaces = new String[]{"http://www.qi4j.org/rdf/model/1.0/", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "http://www.w3.org/2000/01/rdf-schema#"};
        this.serialize(graph, out, prefixes, namespaces);
    }

    @Override
    public void serialize(Iterable<Statement> graph, Writer out, String[] namespacePrefixes, String[] namespaces) throws RDFHandlerException {
        RDFWriterFactory writerFactory;
        try {
            writerFactory = this.writerFactoryClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new InternalError();
        }
        catch (IllegalAccessException e) {
            throw new InternalError();
        }
        RDFWriter writer = writerFactory.getWriter(out);
        writer.startRDF();
        for (int i = 0; i < namespacePrefixes.length; ++i) {
            String namespacePrefix = namespacePrefixes[i];
            String namespace = namespaces[i];
            writer.handleNamespace(namespacePrefix, namespace);
        }
        for (Statement st : graph) {
            writer.handleStatement(st);
        }
        writer.endRDF();
    }
}

