/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.redis;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.service.ServiceActivation;
import org.qi4j.entitystore.redis.RedisAccessors;
import org.qi4j.entitystore.redis.RedisEntityStoreConfiguration;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.spi.entitystore.EntityAlreadyExistsException;
import org.qi4j.spi.entitystore.EntityNotFoundException;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.helpers.MapEntityStore;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisMapEntityStoreMixin
implements ServiceActivation,
RedisAccessors,
MapEntityStore {
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final String NIL = "nil";
    @This
    private Configuration<RedisEntityStoreConfiguration> configuration;
    private JedisPool pool;

    public void activateService() throws Exception {
        this.configuration.refresh();
        RedisEntityStoreConfiguration config = (RedisEntityStoreConfiguration)this.configuration.get();
        String host = config.host().get() == null ? DEFAULT_HOST : (String)config.host().get();
        int port = config.port().get() == null ? 6379 : (Integer)config.port().get();
        int timeout = config.timeout().get() == null ? 2000 : (Integer)config.timeout().get();
        String password = (String)config.password().get();
        int database = config.database().get() == null ? 0 : (Integer)config.database().get();
        this.pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), host, port, timeout, password, database);
    }

    public void passivateService() throws Exception {
        this.pool.destroy();
        this.pool = null;
    }

    @Override
    public JedisPool jedisPool() {
        return this.pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader get(EntityReference entityReference) throws EntityStoreException {
        Jedis jedis = this.pool.getResource();
        try {
            String jsonState = jedis.get(entityReference.identity());
            if (RedisMapEntityStoreMixin.notFound(jsonState)) {
                throw new EntityNotFoundException(entityReference);
            }
            StringReader stringReader = new StringReader(jsonState);
            return stringReader;
        }
        finally {
            this.pool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChanges(MapEntityStore.MapChanges changes) throws IOException {
        final Jedis jedis = this.pool.getResource();
        try {
            changes.visitMap(new MapEntityStore.MapChanger(){

                public Writer newEntity(final EntityReference ref, EntityDescriptor entityDescriptor) throws IOException {
                    return new StringWriter(1000){

                        @Override
                        public void close() throws IOException {
                            super.close();
                            String statusCode = jedis.set(ref.identity(), this.toString(), "NX");
                            if (!"OK".equals(statusCode)) {
                                throw new EntityAlreadyExistsException(ref);
                            }
                        }
                    };
                }

                public Writer updateEntity(final EntityReference ref, EntityDescriptor entityDescriptor) throws IOException {
                    return new StringWriter(1000){

                        @Override
                        public void close() throws IOException {
                            super.close();
                            String statusCode = jedis.set(ref.identity(), this.toString(), "XX");
                            if (!"OK".equals(statusCode)) {
                                throw new EntityNotFoundException(ref);
                            }
                        }
                    };
                }

                public void removeEntity(EntityReference ref, EntityDescriptor entityDescriptor) throws EntityNotFoundException {
                    String jsonState = jedis.get(ref.identity());
                    if (RedisMapEntityStoreMixin.notFound(jsonState)) {
                        throw new EntityNotFoundException(ref);
                    }
                    jedis.del(ref.identity());
                }
            });
        }
        finally {
            this.pool.returnResource(jedis);
        }
    }

    public Input<Reader, IOException> entityStates() {
        return new Input<Reader, IOException>(){

            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super Reader, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                output.receiveFrom((Sender)new Sender<Reader, IOException>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public <ReceiverThrowableType extends Throwable> void sendTo(Receiver<? super Reader, ReceiverThrowableType> receiver) throws ReceiverThrowableType, IOException {
                        Jedis jedis = RedisMapEntityStoreMixin.this.pool.getResource();
                        try {
                            Set keys = jedis.keys("*");
                            for (String key : keys) {
                                String jsonState = jedis.get(key);
                                receiver.receive((Object)new StringReader(jsonState));
                            }
                        }
                        finally {
                            RedisMapEntityStoreMixin.this.pool.returnResource(jedis);
                        }
                    }
                });
            }
        };
    }

    private static boolean notFound(String jsonState) {
        return jsonState == null || NIL.equals(jsonState);
    }
}

