/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.common;

import java.util.List;
import org.qi4j.api.common.Optional;
import org.qi4j.api.common.UseDefaults;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.Property;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.functional.Iterables;
import org.qi4j.library.rest.common.link.Link;
import org.qi4j.library.rest.common.link.LinksUtil;

@Mixins(value={Mixin.class})
public interface Resource
extends ValueComposite {
    @UseDefaults
    public Property<List<Link>> queries();

    public Link query(String var1);

    @UseDefaults
    public Property<List<Link>> commands();

    public Link command(String var1);

    @UseDefaults
    public Property<List<Link>> resources();

    public Link resource(String var1);

    @Optional
    public Property<ValueComposite> index();

    public static abstract class Mixin
    implements Resource {
        @Override
        public Link query(String relation) {
            return (Link)Iterables.single((Iterable)Iterables.filter(LinksUtil.withRel(relation), (Iterable)((Iterable)this.queries().get())));
        }

        @Override
        public Link command(String relation) {
            return (Link)Iterables.single((Iterable)Iterables.filter(LinksUtil.withRel(relation), (Iterable)((Iterable)this.commands().get())));
        }

        @Override
        public Link resource(String relation) {
            return (Link)Iterables.single((Iterable)Iterables.filter(LinksUtil.withRel(relation), (Iterable)((Iterable)this.resources().get())));
        }
    }
}

