/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.common.link;

import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.library.rest.common.link.Link;
import org.qi4j.library.rest.common.link.Links;

public final class LinksUtil {
    public static Specification<Link> withId(final String id) {
        return new Specification<Link>(){

            public boolean satisfiedBy(Link link) {
                return ((String)link.id().get()).equals(id);
            }
        };
    }

    public static Specification<Link> withText(final String text) {
        return new Specification<Link>(){

            public boolean satisfiedBy(Link link) {
                return ((String)link.text().get()).equals(text);
            }
        };
    }

    public static Specification<Link> withRel(final String rel) {
        return new Specification<Link>(){

            public boolean satisfiedBy(Link link) {
                return ((String)link.rel().get()).equals(rel);
            }
        };
    }

    public static Specification<Link> withClass(final String clazz) {
        return new Specification<Link>(){

            public boolean satisfiedBy(Link link) {
                String classes = (String)link.classes().get();
                return classes != null && classes.contains(clazz);
            }
        };
    }

    public static Link withRel(String rel, Links links) {
        return (Link)Iterables.single((Iterable)Iterables.filter(LinksUtil.withRel(rel), (Iterable)((Iterable)links.links().get())));
    }

    public static Link withId(String id, Links links) {
        return (Link)Iterables.single((Iterable)Iterables.filter(LinksUtil.withId(id), (Iterable)((Iterable)links.links().get())));
    }

    public static Function<Link, String> toRel() {
        return new Function<Link, String>(){

            public String map(Link link) {
                return (String)link.rel().get();
            }
        };
    }
}

