/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.common.table;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.qi4j.api.util.Dates;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueBuilderFactory;
import org.qi4j.functional.Function;
import org.qi4j.library.rest.common.table.Cell;
import org.qi4j.library.rest.common.table.Column;
import org.qi4j.library.rest.common.table.Row;
import org.qi4j.library.rest.common.table.Table;
import org.qi4j.library.rest.common.table.TableBuilderFactory;
import org.qi4j.library.rest.common.table.TableQuery;

public class TableBuilder {
    protected ValueBuilderFactory vbf;
    private Map<String, TableBuilderFactory.Column> columns;
    private TableQuery tableQuery;
    protected ValueBuilder<Table> tableBuilder;
    protected ValueBuilder<Row> rowBuilder;

    public TableBuilder(ValueBuilderFactory vbf) {
        this.vbf = vbf;
        this.tableBuilder = vbf.newValueBuilder(Table.class);
    }

    public TableBuilder(ValueBuilderFactory vbf, Map<String, TableBuilderFactory.Column> columns, TableQuery tableQuery) {
        this.vbf = vbf;
        this.columns = columns;
        this.tableQuery = tableQuery;
        this.tableBuilder = vbf.newValueBuilder(Table.class);
        if (tableQuery.select().equals("*")) {
            for (TableBuilderFactory.Column column : columns.values()) {
                this.column(column.getId(), column.getLabel(), column.getType());
            }
        } else {
            for (String columnName : tableQuery.select().split("[, ]")) {
                TableBuilderFactory.Column column = columns.get(columnName.trim());
                if (column == null) continue;
                this.column(column.getId(), column.getLabel(), column.getType());
            }
        }
    }

    public TableBuilder column(String id, String label, String type) {
        ValueBuilder builder = this.vbf.newValueBuilder(Column.class);
        ((Column)builder.prototype()).id().set((Object)id);
        if (this.tableQuery == null || this.tableQuery.label() != null) {
            // empty if block
        }
        ((Column)builder.prototype()).label().set((Object)label);
        ((Column)builder.prototype()).columnType().set((Object)type);
        ((List)((Table)this.tableBuilder.prototype()).cols().get()).add(builder.newInstance());
        return this;
    }

    public TableBuilder rows(Iterable<?> rowObjects) {
        boolean no_format = false;
        boolean no_values = false;
        if (this.tableQuery != null && this.tableQuery.options() != null) {
            if (this.tableQuery.options().contains("no_format")) {
                no_format = true;
            }
            if (this.tableQuery != null && this.tableQuery.options().contains("no_values")) {
                no_values = true;
            }
        }
        for (Object rowObject : rowObjects) {
            this.row();
            for (Column column : (List)((Table)this.tableBuilder.prototype()).cols().get()) {
                Object v = null;
                String f = null;
                Function<?, Object> valueFunction = this.columns.get(column.id().get()).getValueFunction();
                if (!no_values && valueFunction != null) {
                    v = valueFunction.map(rowObject);
                }
                Function<?, String> formattedFunction = this.columns.get(column.id().get()).getFormattedFunction();
                if (!no_format && formattedFunction != null) {
                    f = (String)formattedFunction.map(rowObject);
                } else if (v != null) {
                    f = ((String)column.columnType().get()).equals("datetime") ? Dates.toUtcString((Date)((Date)v)) : (((String)column.columnType().get()).equals("date") ? new SimpleDateFormat("yyyy-MM-dd").format((Date)v) : (((String)column.columnType().get()).equals("timeofday") ? new SimpleDateFormat("HH:mm:ss").format((Date)v) : v.toString()));
                }
                this.cell(v, f);
            }
            this.endRow();
        }
        return this;
    }

    public TableBuilder row() {
        if (this.rowBuilder != null) {
            this.endRow();
        }
        this.rowBuilder = this.vbf.newValueBuilder(Row.class);
        return this;
    }

    public TableBuilder endRow() {
        ((List)((Table)this.tableBuilder.prototype()).rows().get()).add(this.rowBuilder.newInstance());
        this.rowBuilder = null;
        return this;
    }

    public TableBuilder cell(Object v, String f) {
        ValueBuilder cellBuilder = this.vbf.newValueBuilder(Cell.class);
        ((Cell)cellBuilder.prototype()).v().set(v);
        ((Cell)cellBuilder.prototype()).f().set((Object)f);
        ((List)((Row)this.rowBuilder.prototype()).c().get()).add(cellBuilder.newInstance());
        return this;
    }

    public TableBuilder orderBy() {
        if (this.tableQuery.orderBy() != null) {
            String[] orderBy = this.tableQuery.orderBy().split(" ");
            boolean descending = orderBy.length == 2 && orderBy[1].equals("desc");
            int sortIndex = -1;
            List columns = (List)((Table)this.tableBuilder.prototype()).cols().get();
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                if (!((String)column.id().get()).equals(orderBy[0])) continue;
                sortIndex = i;
                break;
            }
            if (sortIndex != -1) {
                final int idx = sortIndex;
                Comparator<Row> comparator = new Comparator<Row>(){

                    @Override
                    public int compare(Row o1, Row o2) {
                        Object o = ((Cell)((List)o1.c().get()).get(idx)).v().get();
                        if (o != null && o instanceof Comparable) {
                            Comparable c1 = (Comparable)o;
                            Comparable c2 = (Comparable)((Cell)((List)o2.c().get()).get(idx)).v().get();
                            return c1.compareTo(c2);
                        }
                        String f1 = (String)((Cell)((List)o1.c().get()).get(idx)).f().get();
                        String f2 = (String)((Cell)((List)o2.c().get()).get(idx)).f().get();
                        return f1.compareTo(f2);
                    }
                };
                if (descending) {
                    comparator = Collections.reverseOrder(comparator);
                }
                Collections.sort((List)((Table)this.tableBuilder.prototype()).rows().get(), comparator);
            }
        }
        return this;
    }

    public TableBuilder paging() {
        int start = 0;
        int end = ((List)((Table)this.tableBuilder.prototype()).rows().get()).size();
        if (this.tableQuery.offset() != null) {
            start = Integer.parseInt(this.tableQuery.offset());
        }
        if (this.tableQuery.limit() != null) {
            end = Math.min(end, start + Integer.parseInt(this.tableQuery.limit()));
        }
        if (start != 0 || end != ((List)((Table)this.tableBuilder.prototype()).rows().get()).size()) {
            ((Table)this.tableBuilder.prototype()).rows().set(((List)((Table)this.tableBuilder.prototype()).rows().get()).subList(start, end));
        }
        return this;
    }

    public Table newTable() {
        if (this.rowBuilder != null) {
            this.endRow();
        }
        return (Table)this.tableBuilder.newInstance();
    }

    public void abortRow() {
        this.rowBuilder = null;
    }
}

