/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.functional;

import java.util.Iterator;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Visitor;

public final class ForEach<T>
implements Iterable<T> {
    private final Iterable<T> iterable;

    public static <T> ForEach<T> forEach(Iterable<T> iterable) {
        return new ForEach<T>(iterable);
    }

    public ForEach(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterable.iterator();
    }

    public ForEach<T> filter(Specification<? super T> specification) {
        return new ForEach<T>(Iterables.filter(specification, this.iterable));
    }

    public <TO> ForEach<TO> map(Function<?, TO> function) {
        return new ForEach<TO>(Iterables.map(function, this.iterable));
    }

    public <TO> ForEach<TO> flatten() {
        Iterable<Iterable<TO>> original = this.iterable();
        Iterable iterable1 = Iterables.flattenIterables(original);
        return new ForEach(iterable1);
    }

    private <TO> Iterable<Iterable<TO>> iterable() {
        return this.iterable;
    }

    public T last() {
        T lastItem = null;
        for (T item : this.iterable) {
            lastItem = item;
        }
        return lastItem;
    }

    public <ThrowableType extends Throwable> boolean visit(Visitor<T, ThrowableType> visitor) throws ThrowableType {
        for (T item : this.iterable) {
            if (visitor.visit(item)) continue;
            return false;
        }
        return true;
    }
}

