/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.functional;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.qi4j.functional.Function;
import org.qi4j.functional.Function2;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;

public final class Functions {
    public static <A, B, C> Function2<Function<? super B, C>, Function<A, B>, Function<A, C>> compose() {
        return new Function2<Function<? super B, C>, Function<A, B>, Function<A, C>>(){

            @Override
            public Function<A, C> map(Function<? super B, C> bcFunction, Function<A, B> abFunction) {
                return Functions.compose(bcFunction, abFunction);
            }
        };
    }

    public static <FROM, MIDDLE, TO> Function<FROM, TO> compose(final Function<? super MIDDLE, TO> outer, final Function<FROM, MIDDLE> inner) {
        return new Function<FROM, TO>(){

            @Override
            public TO map(FROM from) {
                return outer.map(inner.map(from));
            }
        };
    }

    public static <TO, FROM extends TO> Function<FROM, TO> identity() {
        return new Function<FROM, TO>(){

            @Override
            public TO map(FROM from) {
                return from;
            }
        };
    }

    public static <FROM, TO> Function<FROM, TO> fromMap(final Map<FROM, TO> map) {
        return new Function<FROM, TO>(){

            @Override
            public TO map(FROM from) {
                return map.get(from);
            }
        };
    }

    public static <T> Function<T, T> withDefault(final T defaultValue) {
        return new Function<T, T>(){

            @Override
            public T map(T from) {
                if (from == null) {
                    return defaultValue;
                }
                return from;
            }
        };
    }

    public static Function<Number, Long> longSum() {
        return new Function<Number, Long>(){
            long sum;

            @Override
            public Long map(Number number) {
                this.sum += number.longValue();
                return this.sum;
            }
        };
    }

    public static Function<Number, Integer> intSum() {
        return new Function<Number, Integer>(){
            int sum;

            @Override
            public Integer map(Number number) {
                this.sum += number.intValue();
                return this.sum;
            }
        };
    }

    public static <T> Function<T, Integer> count(final Specification<T> specification) {
        return new Function<T, Integer>(){
            int count;

            @Override
            public Integer map(T item) {
                if (specification.satisfiedBy(item)) {
                    ++this.count;
                }
                return this.count;
            }
        };
    }

    public static <T> Function<T, Integer> indexOf(final Specification<T> specification) {
        return new Function<T, Integer>(){
            int index = -1;
            int current = 0;

            @Override
            public Integer map(T item) {
                if (this.index == -1 && specification.satisfiedBy(item)) {
                    this.index = this.current;
                }
                ++this.current;
                return this.index;
            }
        };
    }

    public static <T> int indexOf(T item, Iterable<T> iterable) {
        return Iterables.first(Iterables.filter(Specifications.not(Specifications.in(-1)), Iterables.map(Functions.indexOf(Specifications.in(item)), iterable)));
    }

    public static <T> Function<T, T> filteredMap(final Specification<T> specification, final Function<T, T> function) {
        return new Function<T, T>(){

            @Override
            public T map(T from) {
                return specification.satisfiedBy(from) ? function.map(from) : from;
            }
        };
    }

    public static <T> Comparator<T> comparator(final Function<T, Comparable> comparableFunction) {
        return new Comparator<T>(){
            Map<T, Comparable> compareKeys = new HashMap();

            @Override
            public int compare(T o1, T o2) {
                Comparable key2;
                Comparable key1 = this.compareKeys.get(o1);
                if (key1 == null) {
                    key1 = (Comparable)comparableFunction.map(o1);
                    this.compareKeys.put(o1, key1);
                }
                if ((key2 = this.compareKeys.get(o2)) == null) {
                    key2 = (Comparable)comparableFunction.map(o2);
                    this.compareKeys.put(o2, key2);
                }
                return key1.compareTo(key2);
            }
        };
    }

    private Functions() {
    }
}

