/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.functional;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.qi4j.functional.Function;
import org.qi4j.functional.Specification;

public final class Iterables {
    private static final Iterable EMPTY = new Iterable(){
        Iterator iterator = new Iterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
            }
        };

        public Iterator iterator() {
            return this.iterator;
        }
    };

    public static <T> Iterable<T> empty() {
        return EMPTY;
    }

    public static <T> Iterable<T> constant(final T item) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return true;
                    }

                    @Override
                    public T next() {
                        return item;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> limit(final int limitItems, final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator = iterable.iterator();
                return new Iterator<T>(){
                    int count;

                    @Override
                    public boolean hasNext() {
                        return this.count < limitItems && iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        ++this.count;
                        return iterator.next();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> unique(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator = iterable.iterator();
                return new Iterator<T>(){
                    private final Set<T> items = new HashSet();
                    private T nextItem;

                    @Override
                    public boolean hasNext() {
                        while (iterator.hasNext()) {
                            this.nextItem = iterator.next();
                            if (!this.items.add(this.nextItem)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public T next() {
                        if (this.nextItem == null && !this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return this.nextItem;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public static <T, C extends Collection<T>> C addAll(C collection, Iterable<? extends T> iterable) {
        for (T item : iterable) {
            collection.add(item);
        }
        return collection;
    }

    public static long count(Iterable<?> iterable) {
        long c = 0L;
        for (Object anIterable : iterable) {
            ++c;
        }
        return c;
    }

    public static <X> Iterable<X> filter(Specification<?> specification, Iterable<X> i) {
        return new FilterIterable(i, specification);
    }

    public static <X> X first(Iterable<X> i) {
        Iterator<X> iter = i.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public static <X> X single(Iterable<X> i) {
        Iterator<X> iter = i.iterator();
        if (iter.hasNext()) {
            X result = iter.next();
            if (iter.hasNext()) {
                throw new IllegalArgumentException("More than one element in iterable");
            }
            return result;
        }
        throw new IllegalArgumentException("No elements in iterable");
    }

    public static <X> Iterable<X> skip(final int skip, final Iterable<X> iterable) {
        return new Iterable<X>(){

            @Override
            public Iterator<X> iterator() {
                Iterator iterator = iterable.iterator();
                for (int i = 0; i < skip; ++i) {
                    if (!iterator.hasNext()) {
                        return Iterables.empty().iterator();
                    }
                    iterator.next();
                }
                return iterator;
            }
        };
    }

    public static <X> X last(Iterable<X> i) {
        Iterator<X> iter = i.iterator();
        X item = null;
        while (iter.hasNext()) {
            item = iter.next();
        }
        return item;
    }

    public static <X> Iterable<X> reverse(Iterable<X> iterable) {
        List<X> list = Iterables.toList(iterable);
        Collections.reverse(list);
        return list;
    }

    public static <T> boolean matchesAny(Specification<? super T> specification, Iterable<T> iterable) {
        boolean result = false;
        for (T item : iterable) {
            if (!specification.satisfiedBy(item)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static <T> boolean matchesAll(Specification<? super T> specification, Iterable<T> iterable) {
        boolean result = true;
        for (T item : iterable) {
            if (specification.satisfiedBy(item)) continue;
            result = false;
        }
        return result;
    }

    public static <X> Iterable<X> flatten(Iterable<?> ... multiIterator) {
        return new FlattenIterable(Iterables.cast(Arrays.asList(multiIterator)));
    }

    public static <X, I extends Iterable<? extends X>> Iterable<X> flattenIterables(Iterable<I> multiIterator) {
        return new FlattenIterable(Iterables.cast(multiIterator));
    }

    @SafeVarargs
    public static <T> Iterable<T> mix(final Iterable<T> ... iterables) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final List iterators = Iterables.toList(Iterables.map(new Function<Iterable<T>, Iterator<T>>(){

                    @Override
                    public Iterator<T> map(Iterable<T> iterable) {
                        return iterable.iterator();
                    }
                }, Iterables.iterable(iterables)));
                return new Iterator<T>(){
                    Iterator<Iterator<T>> iterator;
                    Iterator<T> iter;

                    @Override
                    public boolean hasNext() {
                        for (Iterator iterator : iterators) {
                            if (!iterator.hasNext()) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public T next() {
                        if (this.iterator == null) {
                            this.iterator = iterators.iterator();
                        }
                        while (this.iterator.hasNext()) {
                            this.iter = this.iterator.next();
                            if (!this.iter.hasNext()) continue;
                            return this.iter.next();
                        }
                        this.iterator = null;
                        return this.next();
                    }

                    @Override
                    public void remove() {
                        if (this.iter != null) {
                            this.iter.remove();
                        }
                    }
                };
            }
        };
    }

    public static <FROM, TO> Iterable<TO> map(Function<?, TO> function, Iterable<FROM> from) {
        return new MapIterable(from, function);
    }

    public static <T> Iterable<T> iterable(Enumeration<T> enumeration) {
        ArrayList<T> list = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            T item = enumeration.nextElement();
            list.add(item);
        }
        return list;
    }

    @SafeVarargs
    public static <T> Iterable<T> iterable(T ... items) {
        return Arrays.asList(items);
    }

    public static <T> Iterable<T> cast(Iterable<?> iterable) {
        Iterable<?> iter = iterable;
        return iter;
    }

    public static <FROM, TO> Function<FROM, TO> cast() {
        return new Function<FROM, TO>(){

            @Override
            public TO map(FROM from) {
                return from;
            }
        };
    }

    public static <FROM, TO> TO fold(Function<? super FROM, TO> function, Iterable<? extends FROM> i) {
        return Iterables.last(Iterables.map(function, i));
    }

    public static <T> Iterable<T> prepend(final T item, final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    T first;
                    Iterator<T> iterator;
                    {
                        this.first = item;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.first != null) {
                            return true;
                        }
                        if (this.iterator == null) {
                            this.iterator = iterable.iterator();
                        }
                        return this.iterator.hasNext();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public T next() {
                        if (this.first != null) {
                            try {
                                Object t = this.first;
                                return t;
                            }
                            finally {
                                this.first = null;
                            }
                        }
                        return this.iterator.next();
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> append(final T item, final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator = iterable.iterator();
                return new Iterator<T>(){
                    T last;
                    {
                        this.last = item;
                    }

                    @Override
                    public boolean hasNext() {
                        if (iterator.hasNext()) {
                            return true;
                        }
                        return this.last != null;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public T next() {
                        if (iterator.hasNext()) {
                            return iterator.next();
                        }
                        try {
                            Object t = this.last;
                            return t;
                        }
                        finally {
                            this.last = null;
                        }
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    @SafeVarargs
    public static <T> Iterable<T> debug(String format, Iterable<T> iterable, final Function<T, String> ... functions) {
        MessageFormat msgFormat = new MessageFormat(format);
        return Iterables.map(new Function<T, T>(){

            @Override
            public T map(T t) {
                if (functions.length != 0) {
                    String[] mapped = new String[functions.length];
                    for (int i = 0; i < functions.length; ++i) {
                        Function function = functions[i];
                        mapped[i] = (String)function.map(t);
                    }
                }
                return t;
            }
        }, iterable);
    }

    public static <T> Iterable<T> cache(Iterable<T> iterable) {
        return new CacheIterable(iterable);
    }

    public static <T> String toString(Iterable<T> iterable) {
        return Iterables.toString(iterable, new Function<T, String>(){

            @Override
            public String map(T t) {
                return t == null ? "[null]" : t.toString();
            }
        }, ",");
    }

    public static <T> String toString(Iterable<T> iterable, Function<T, String> toStringFunction, String separator) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (T item : iterable) {
            if (!first) {
                builder.append(separator);
            }
            builder.append(toStringFunction.map(item));
            first = false;
        }
        return builder.toString();
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        return Iterables.addAll(new ArrayList(), iterable);
    }

    public static Object[] toArray(Iterable<Object> iterable) {
        return Iterables.toArray(Object.class, iterable);
    }

    public static <T> T[] toArray(Class<T> componentType, Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        List<Object> list = Iterables.toList(iterable);
        return list.toArray((Object[])Array.newInstance(componentType, list.size()));
    }

    public static <X extends Comparable> Iterable<X> sort(Iterable<X> iterable) {
        List<X> list = Iterables.toList(iterable);
        Collections.sort(list);
        return list;
    }

    public static <X> Iterable<X> sort(Comparator<? super X> comparator, Iterable<X> iterable) {
        List<X> list = Iterables.toList(iterable);
        Collections.sort(list, comparator);
        return list;
    }

    private Iterables() {
    }

    private static class CacheIterable<T>
    implements Iterable<T> {
        private final Iterable<T> iterable;
        private Iterable<T> cache;

        private CacheIterable(Iterable<T> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.cache != null) {
                return this.cache.iterator();
            }
            final Iterator<T> source = this.iterable.iterator();
            return new Iterator<T>(){
                List<T> iteratorCache = new ArrayList();

                @Override
                public boolean hasNext() {
                    boolean hasNext = source.hasNext();
                    if (!hasNext) {
                        CacheIterable.this.cache = this.iteratorCache;
                    }
                    return hasNext;
                }

                @Override
                public T next() {
                    Object next = source.next();
                    this.iteratorCache.add(next);
                    return next;
                }

                @Override
                public void remove() {
                }
            };
        }
    }

    private static class FlattenIterable<T, I extends Iterable<? extends T>>
    implements Iterable<T> {
        private final Iterable<I> iterable;

        private FlattenIterable(Iterable<I> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            return new FlattenIterator(this.iterable.iterator());
        }

        static class FlattenIterator<T, I extends Iterable<? extends T>>
        implements Iterator<T> {
            private final Iterator<I> iterator;
            private Iterator<? extends T> currentIterator;

            private FlattenIterator(Iterator<I> iterator) {
                this.iterator = iterator;
                this.currentIterator = null;
            }

            @Override
            public boolean hasNext() {
                if (this.currentIterator == null) {
                    if (this.iterator.hasNext()) {
                        Iterable next = (Iterable)this.iterator.next();
                        this.currentIterator = next.iterator();
                    } else {
                        return false;
                    }
                }
                while (!this.currentIterator.hasNext() && this.iterator.hasNext()) {
                    this.currentIterator = ((Iterable)this.iterator.next()).iterator();
                }
                return this.currentIterator.hasNext();
            }

            @Override
            public T next() {
                return this.currentIterator.next();
            }

            @Override
            public void remove() {
                if (this.currentIterator == null) {
                    throw new IllegalStateException();
                }
                this.currentIterator.remove();
            }
        }
    }

    private static class FilterIterable<T>
    implements Iterable<T> {
        private final Iterable<T> iterable;
        private final Specification<? super T> specification;

        private FilterIterable(Iterable<T> iterable, Specification<? super T> specification) {
            this.iterable = iterable;
            this.specification = specification;
        }

        @Override
        public Iterator<T> iterator() {
            return new FilterIterator(this.iterable.iterator(), this.specification);
        }

        private static class FilterIterator<T>
        implements Iterator<T> {
            private final Iterator<T> iterator;
            private final Specification<? super T> specification;
            private T currentValue;
            boolean finished = false;
            boolean nextConsumed = true;

            private FilterIterator(Iterator<T> iterator, Specification<? super T> specification) {
                this.specification = specification;
                this.iterator = iterator;
            }

            public boolean moveToNextValid() {
                boolean found = false;
                while (!found && this.iterator.hasNext()) {
                    T currentValue = this.iterator.next();
                    boolean satisfies = this.specification.satisfiedBy(currentValue);
                    if (!satisfies) continue;
                    found = true;
                    this.currentValue = currentValue;
                    this.nextConsumed = false;
                }
                if (!found) {
                    this.finished = true;
                }
                return found;
            }

            @Override
            public T next() {
                if (!this.nextConsumed) {
                    this.nextConsumed = true;
                    return this.currentValue;
                }
                if (!this.finished && this.moveToNextValid()) {
                    this.nextConsumed = true;
                    return this.currentValue;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return !this.finished && (!this.nextConsumed || this.moveToNextValid());
            }

            @Override
            public void remove() {
            }
        }
    }

    private static class MapIterable<FROM, TO>
    implements Iterable<TO> {
        private final Iterable<FROM> from;
        private final Function<? super FROM, TO> function;

        private MapIterable(Iterable<FROM> from, Function<? super FROM, TO> function) {
            this.from = from;
            this.function = function;
        }

        @Override
        public Iterator<TO> iterator() {
            return new MapIterator(this.from.iterator(), this.function);
        }

        static class MapIterator<FROM, TO>
        implements Iterator<TO> {
            private final Iterator<FROM> fromIterator;
            private final Function<? super FROM, TO> function;

            private MapIterator(Iterator<FROM> fromIterator, Function<? super FROM, TO> function) {
                this.fromIterator = fromIterator;
                this.function = function;
            }

            @Override
            public boolean hasNext() {
                return this.fromIterator.hasNext();
            }

            @Override
            public TO next() {
                FROM from = this.fromIterator.next();
                return this.function.map(from);
            }

            @Override
            public void remove() {
                this.fromIterator.remove();
            }
        }
    }
}

