/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.sql.assembly;

import javax.sql.DataSource;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.bootstrap.Assemblers;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.library.circuitbreaker.CircuitBreaker;
import org.qi4j.library.sql.datasource.DataSources;

public class ExternalDataSourceAssembler
extends Assemblers.VisibilityIdentity<ExternalDataSourceAssembler> {
    public static String DEFAULT_DATASOURCE_IDENTITY = "external-datasource";
    private DataSource externalDataSource;
    private CircuitBreaker circuitBreaker;

    public ExternalDataSourceAssembler() {
        this.identifiedBy(DEFAULT_DATASOURCE_IDENTITY);
    }

    public ExternalDataSourceAssembler(DataSource externalDataSource) {
        NullArgumentException.validateNotNull((String)"DataSource", (Object)externalDataSource);
        this.externalDataSource = externalDataSource;
    }

    public ExternalDataSourceAssembler withCircuitBreaker() {
        this.circuitBreaker = DataSources.newDataSourceCircuitBreaker();
        return this;
    }

    public ExternalDataSourceAssembler withCircuitBreaker(CircuitBreaker circuitBreaker) {
        NullArgumentException.validateNotNull((String)"CircuitBreaker", (Object)circuitBreaker);
        this.circuitBreaker = circuitBreaker;
        return this;
    }

    public void assemble(ModuleAssembly module) throws AssemblyException {
        if (this.circuitBreaker != null) {
            this.externalDataSource = DataSources.wrapWithCircuitBreaker(this.identity(), this.externalDataSource, this.circuitBreaker);
        }
        module.importedServices(new Class[]{DataSource.class}).identifiedBy(this.identity()).visibleIn(this.visibility()).setMetaInfo((Object)this.externalDataSource);
    }
}

