/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.sql.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.qi4j.functional.Visitor;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.library.sql.common.SQLUtil;

public class Databases {
    DataSource source;

    public Databases(DataSource source) {
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql) throws SQLException {
        int n;
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = this.source.getConnection();
            stmt = connection.prepareStatement(sql);
            n = stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtil.closeQuietly(stmt);
            SQLUtil.closeQuietly(connection);
            throw throwable;
        }
        SQLUtil.closeQuietly(stmt);
        SQLUtil.closeQuietly(connection);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql, StatementVisitor visitor) throws SQLException {
        int n;
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = this.source.getConnection();
            stmt = connection.prepareStatement(sql);
            visitor.visit(stmt);
            n = stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtil.closeQuietly(stmt);
            SQLUtil.closeQuietly(connection);
            throw throwable;
        }
        SQLUtil.closeQuietly(stmt);
        SQLUtil.closeQuietly(connection);
        return n;
    }

    public void query(String sql, ResultSetVisitor visitor) throws SQLException {
        this.query(sql, null, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(String sql, StatementVisitor statement, ResultSetVisitor resultsetVisitor) throws SQLException {
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            connection = this.source.getConnection();
            stmt = connection.prepareStatement(sql);
            if (statement != null) {
                statement.visit(stmt);
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                if (resultsetVisitor.visit(resultSet)) continue;
            }
        }
        catch (Throwable throwable) {
            SQLUtil.closeQuietly(resultSet);
            SQLUtil.closeQuietly(stmt);
            SQLUtil.closeQuietly(connection);
            throw throwable;
        }
        {
            SQLUtil.closeQuietly(resultSet);
            SQLUtil.closeQuietly(stmt);
            SQLUtil.closeQuietly(connection);
            return;
        }
        resultSet.close();
        SQLUtil.closeQuietly(resultSet);
        SQLUtil.closeQuietly(stmt);
        SQLUtil.closeQuietly(connection);
    }

    public Input<ResultSet, SQLException> query(final String sql) {
        return new Input<ResultSet, SQLException>(){

            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super ResultSet, ReceiverThrowableType> output) throws SQLException, ReceiverThrowableType {
                output.receiveFrom((Sender)new Sender<ResultSet, SQLException>(){

                    public <ReceiverThrowableType extends Throwable> void sendTo(final Receiver<? super ResultSet, ReceiverThrowableType> receiver) throws ReceiverThrowableType, SQLException {
                        Databases.this.query(sql, new ResultSetVisitor(){

                            public boolean visit(ResultSet visited) throws SQLException {
                                try {
                                    receiver.receive((Object)visited);
                                }
                                catch (Throwable receiverThrowableType) {
                                    throw new SQLException(receiverThrowableType);
                                }
                                return true;
                            }
                        });
                    }
                });
            }
        };
    }

    public Input<ResultSet, SQLException> query(final String sql, final StatementVisitor visitor) {
        return new Input<ResultSet, SQLException>(){

            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super ResultSet, ReceiverThrowableType> output) throws SQLException, ReceiverThrowableType {
                output.receiveFrom((Sender)new Sender<ResultSet, SQLException>(){

                    public <ReceiverThrowableType extends Throwable> void sendTo(final Receiver<? super ResultSet, ReceiverThrowableType> receiver) throws ReceiverThrowableType, SQLException {
                        Databases.this.query(sql, visitor, new ResultSetVisitor(){

                            public boolean visit(ResultSet visited) throws SQLException {
                                try {
                                    receiver.receive((Object)visited);
                                }
                                catch (Throwable receiverThrowableType) {
                                    throw new SQLException(receiverThrowableType);
                                }
                                return true;
                            }
                        });
                    }
                });
            }
        };
    }

    public static interface ResultSetVisitor
    extends Visitor<ResultSet, SQLException> {
    }

    public static interface StatementVisitor {
        public void visit(PreparedStatement var1) throws SQLException;
    }
}

