/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.sql.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.PropertyMapper;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.service.ImportedServiceDescriptor;
import org.qi4j.api.service.ServiceImporter;
import org.qi4j.api.service.ServiceImporterException;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.usecase.UsecaseBuilder;
import org.qi4j.library.circuitbreaker.CircuitBreaker;
import org.qi4j.library.conversion.values.EntityToValue;
import org.qi4j.library.sql.datasource.DataSourceConfiguration;
import org.qi4j.library.sql.datasource.DataSourceConfigurationValue;
import org.qi4j.library.sql.datasource.DataSourceServiceImporterActivation;
import org.qi4j.library.sql.datasource.DataSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceServiceImporterMixin<PooledDataSourceType extends DataSource>
implements ServiceImporter<DataSource>,
DataSourceServiceImporterActivation {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataSourceServiceImporterMixin.class);
    private final Map<String, DataSourceConfigurationValue> configs = new HashMap<String, DataSourceConfigurationValue>();
    private final Map<String, PooledDataSourceType> pools = new HashMap<String, PooledDataSourceType>();
    private final Map<DataSource, CircuitBreaker> circuitBreakers = new HashMap<DataSource, CircuitBreaker>();
    @Structure
    protected Module module;
    @Service
    private EntityToValue entityToValue;

    @Override
    public final void passivateDataSourceService() throws Exception {
        for (DataSource pool : this.pools.values()) {
            this.passivateDataSourcePool(pool);
        }
        this.pools.clear();
        this.configs.clear();
        this.circuitBreakers.clear();
    }

    public final synchronized DataSource importService(ImportedServiceDescriptor importedServiceDescriptor) throws ServiceImporterException {
        CircuitBreaker circuitBreaker;
        DataSource pool = (DataSource)this.pools.get(importedServiceDescriptor.identity());
        if (pool == null) {
            try {
                DataSourceConfigurationValue config = this.getConfiguration(importedServiceDescriptor.identity());
                if (!((Boolean)config.enabled().get()).booleanValue()) {
                    throw new ServiceImporterException("DataSource not enabled");
                }
                pool = this.setupDataSourcePool(config);
                this.pools.put(importedServiceDescriptor.identity(), pool);
                LOGGER.info("Starting up DataSource '" + importedServiceDescriptor.identity() + "' for: {}@{}", config.username().get(), config.url().get());
            }
            catch (Exception e) {
                throw new ServiceImporterException((Throwable)e);
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(null);
            try {
                pool.getConnection().close();
                LOGGER.info("Database for DataSource is up!");
            }
            catch (SQLException e) {
                LOGGER.warn("Database for DataSource " + importedServiceDescriptor.identity() + " is not currently available");
                throw new ServiceImporterException("Database for DataSource " + importedServiceDescriptor.identity() + " is not currently available", (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        if ((circuitBreaker = (CircuitBreaker)importedServiceDescriptor.metaInfo(CircuitBreaker.class)) != null) {
            DataSource wrappedDataSource = DataSources.wrapWithCircuitBreaker(importedServiceDescriptor.identity(), pool, circuitBreaker);
            this.circuitBreakers.put(pool, circuitBreaker);
            return wrappedDataSource;
        }
        return pool;
    }

    private DataSourceConfigurationValue getConfiguration(String identity) throws InstantiationException {
        DataSourceConfigurationValue config = this.configs.get(identity);
        if (config == null) {
            UnitOfWork uow = this.module.newUnitOfWork(UsecaseBuilder.newUsecase((String)"Create DataSource pool configuration"));
            try {
                DataSourceConfiguration configEntity = (DataSourceConfiguration)uow.get(DataSourceConfiguration.class, identity);
                config = (DataSourceConfigurationValue)this.entityToValue.convert(DataSourceConfigurationValue.class, (Object)configEntity);
            }
            catch (NoSuchEntityException e) {
                EntityBuilder configBuilder = uow.newEntityBuilder(DataSourceConfiguration.class, identity);
                String s = identity + ".properties";
                InputStream asStream = DataSourceConfiguration.class.getClassLoader().getResourceAsStream(s);
                if (asStream != null) {
                    try {
                        PropertyMapper.map((InputStream)asStream, (Composite)((Composite)configBuilder.instance()));
                    }
                    catch (IOException e1) {
                        uow.discard();
                        InstantiationException exception = new InstantiationException("Could not read underlying Properties file.");
                        exception.initCause(e1);
                        throw exception;
                    }
                }
                DataSourceConfiguration configEntity = (DataSourceConfiguration)configBuilder.newInstance();
                config = (DataSourceConfigurationValue)this.entityToValue.convert(DataSourceConfigurationValue.class, (Object)configEntity);
                try {
                    uow.complete();
                }
                catch (UnitOfWorkCompletionException e2) {
                    InstantiationException exception = new InstantiationException("Could not save configuration in JavaPreferences.");
                    exception.initCause(e2);
                    throw exception;
                }
            }
            this.configs.put(identity, config);
        }
        return config;
    }

    public final boolean isAvailable(DataSource instance) {
        if (this.pools.containsValue(instance)) {
            CircuitBreaker circuitBreaker = this.circuitBreakers.get(instance);
            if (circuitBreaker != null) {
                return circuitBreaker.isOn();
            }
            return true;
        }
        return false;
    }

    protected abstract PooledDataSourceType setupDataSourcePool(DataSourceConfigurationValue var1) throws Exception;

    protected abstract void passivateDataSourcePool(PooledDataSourceType var1) throws Exception;
}

