/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.sql.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import javax.sql.DataSource;
import org.qi4j.api.service.ServiceImporterException;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Specifications;
import org.qi4j.library.circuitbreaker.CircuitBreaker;
import org.qi4j.library.circuitbreaker.CircuitBreakers;

public class DataSources {
    public static CircuitBreaker newDataSourceCircuitBreaker() {
        return DataSources.newDataSourceCircuitBreaker(5, 300000L);
    }

    public static CircuitBreaker newDataSourceCircuitBreaker(int threshold, long timeout) {
        Specification in = CircuitBreakers.in((Class[])new Class[]{ConnectException.class});
        return new CircuitBreaker(threshold, timeout, Specifications.not((Specification)CircuitBreakers.rootCause((Specification)in)));
    }

    public static DataSource wrapWithCircuitBreaker(final String dataSourceIdentity, final DataSource pool, final CircuitBreaker circuitBreaker) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (!circuitBreaker.isOn()) {
                    Throwable throwable = circuitBreaker.lastThrowable();
                    if (throwable != null) {
                        throw throwable;
                    }
                    throw new ServiceImporterException("Circuit breaker for DataSource " + dataSourceIdentity + " is not on");
                }
                try {
                    Object result = method.invoke((Object)pool, args);
                    circuitBreaker.success();
                    return result;
                }
                catch (IllegalAccessException e) {
                    circuitBreaker.throwable((Throwable)e);
                    throw e;
                }
                catch (IllegalArgumentException e) {
                    circuitBreaker.throwable((Throwable)e);
                    throw e;
                }
                catch (InvocationTargetException e) {
                    circuitBreaker.throwable(e.getCause());
                    throw e.getCause();
                }
            }
        };
        return (DataSource)Proxy.newProxyInstance(DataSource.class.getClassLoader(), new Class[]{DataSource.class}, handler);
    }

    private DataSources() {
    }
}

