/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.jdbm;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.Serializer;
import jdbm.btree.BTree;
import jdbm.helper.ByteArrayComparator;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import jdbm.recman.CacheRecordManager;
import org.qi4j.api.common.Optional;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.entitystore.jdbm.JdbmConfiguration;
import org.qi4j.entitystore.jdbm.JdbmEntityStoreActivation;
import org.qi4j.io.Files;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.library.fileconfig.FileConfiguration;
import org.qi4j.library.locking.ReadLock;
import org.qi4j.library.locking.WriteLock;
import org.qi4j.spi.entitystore.BackupRestore;
import org.qi4j.spi.entitystore.EntityNotFoundException;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.helpers.MapEntityStore;

public class JdbmEntityStoreMixin
implements JdbmEntityStoreActivation,
MapEntityStore,
BackupRestore {
    @Optional
    @Service
    FileConfiguration fileConfiguration;
    @This
    private Configuration<JdbmConfiguration> config;
    @Uses
    private ServiceDescriptor descriptor;
    private RecordManager recordManager;
    private BTree index;
    private Serializer serializer;
    @This
    ReadWriteLock lock;

    @Override
    public void setUpJdbm() throws Exception {
        this.initialize();
    }

    @Override
    public void tearDownJdbm() throws Exception {
        this.recordManager.close();
    }

    @ReadLock
    public Reader get(EntityReference entityReference) throws EntityStoreException {
        try {
            Long stateIndex = this.getStateIndex(entityReference.identity());
            if (stateIndex == null) {
                throw new EntityNotFoundException(entityReference);
            }
            byte[] serializedState = (byte[])this.recordManager.fetch(stateIndex.longValue(), this.serializer);
            if (serializedState == null) {
                throw new EntityNotFoundException(entityReference);
            }
            return new StringReader(new String(serializedState, "UTF-8"));
        }
        catch (IOException e) {
            throw new EntityStoreException((Throwable)e);
        }
    }

    @WriteLock
    public void applyChanges(MapEntityStore.MapChanges changes) throws IOException {
        try {
            changes.visitMap(new MapEntityStore.MapChanger(){

                public Writer newEntity(final EntityReference ref, EntityDescriptor descriptor) throws IOException {
                    return new StringWriter(1000){

                        @Override
                        public void close() throws IOException {
                            super.close();
                            byte[] stateArray = this.toString().getBytes("UTF-8");
                            long stateIndex = JdbmEntityStoreMixin.this.recordManager.insert((Object)stateArray, JdbmEntityStoreMixin.this.serializer);
                            String indexKey = ref.toString();
                            JdbmEntityStoreMixin.this.index.insert((Object)indexKey.getBytes("UTF-8"), (Object)stateIndex, false);
                        }
                    };
                }

                public Writer updateEntity(final EntityReference ref, EntityDescriptor descriptor) throws IOException {
                    return new StringWriter(1000){

                        @Override
                        public void close() throws IOException {
                            super.close();
                            Long stateIndex = JdbmEntityStoreMixin.this.getStateIndex(ref.toString());
                            byte[] stateArray = this.toString().getBytes("UTF-8");
                            JdbmEntityStoreMixin.this.recordManager.update(stateIndex.longValue(), (Object)stateArray, JdbmEntityStoreMixin.this.serializer);
                        }
                    };
                }

                public void removeEntity(EntityReference ref, EntityDescriptor descriptor) throws EntityNotFoundException {
                    try {
                        Long stateIndex = JdbmEntityStoreMixin.this.getStateIndex(ref.toString());
                        JdbmEntityStoreMixin.this.recordManager.delete(stateIndex.longValue());
                        JdbmEntityStoreMixin.this.index.remove((Object)ref.toString().getBytes("UTF-8"));
                    }
                    catch (IOException e) {
                        throw new EntityStoreException((Throwable)e);
                    }
                }
            });
            this.recordManager.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.recordManager.rollback();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof EntityStoreException) {
                throw (EntityStoreException)e;
            }
            throw new IOException(e);
        }
    }

    public Input<Reader, IOException> entityStates() {
        return new Input<Reader, IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super Reader, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                JdbmEntityStoreMixin.this.lock.writeLock().lock();
                try {
                    output.receiveFrom((Sender)new Sender<Reader, IOException>(){

                        public <ReceiverThrowableType extends Throwable> void sendTo(Receiver<? super Reader, ReceiverThrowableType> receiver) throws ReceiverThrowableType, IOException {
                            TupleBrowser browser = JdbmEntityStoreMixin.this.index.browse();
                            Tuple tuple = new Tuple();
                            while (browser.getNext(tuple)) {
                                String id = new String((byte[])tuple.getKey(), "UTF-8");
                                Long stateIndex = JdbmEntityStoreMixin.this.getStateIndex(id);
                                if (stateIndex == null) continue;
                                byte[] serializedState = (byte[])JdbmEntityStoreMixin.this.recordManager.fetch(stateIndex.longValue(), JdbmEntityStoreMixin.this.serializer);
                                receiver.receive((Object)new StringReader(new String(serializedState, "UTF-8")));
                            }
                        }
                    });
                }
                finally {
                    JdbmEntityStoreMixin.this.lock.writeLock().unlock();
                }
            }
        };
    }

    public Input<String, IOException> backup() {
        return new Input<String, IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super String, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                JdbmEntityStoreMixin.this.lock.readLock().lock();
                try {
                    output.receiveFrom((Sender)new Sender<String, IOException>(){

                        public <ReceiverThrowableType extends Throwable> void sendTo(Receiver<? super String, ReceiverThrowableType> receiver) throws ReceiverThrowableType, IOException {
                            TupleBrowser browser = JdbmEntityStoreMixin.this.index.browse();
                            Tuple tuple = new Tuple();
                            while (browser.getNext(tuple)) {
                                String id = new String((byte[])tuple.getKey(), "UTF-8");
                                Long stateIndex = JdbmEntityStoreMixin.this.getStateIndex(id);
                                if (stateIndex == null) continue;
                                byte[] serializedState = (byte[])JdbmEntityStoreMixin.this.recordManager.fetch(stateIndex.longValue(), JdbmEntityStoreMixin.this.serializer);
                                receiver.receive((Object)new String(serializedState, "UTF-8"));
                            }
                        }
                    });
                }
                finally {
                    JdbmEntityStoreMixin.this.lock.readLock().unlock();
                }
            }
        };
    }

    public Output<String, IOException> restore() {
        return new Output<String, IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <SenderThrowableType extends Throwable> void receiveFrom(Sender<? extends String, SenderThrowableType> sender) throws IOException, SenderThrowableType {
                File dbFile = new File(JdbmEntityStoreMixin.this.getDatabaseName() + ".db");
                File lgFile = new File(JdbmEntityStoreMixin.this.getDatabaseName() + ".lg");
                File tempDatabase = Files.createTemporayFileOf((File)dbFile);
                final RecordManager recordManager = RecordManagerFactory.createRecordManager((String)tempDatabase.getAbsolutePath(), (Properties)new Properties());
                ByteArrayComparator comparator = new ByteArrayComparator();
                final BTree index = BTree.createInstance((RecordManager)recordManager, (Comparator)comparator, (Serializer)JdbmEntityStoreMixin.this.serializer, (Serializer)DefaultSerializer.INSTANCE, (int)16);
                recordManager.setNamedObject("index", index.getRecid());
                recordManager.commit();
                try {
                    sender.sendTo((Receiver)new Receiver<String, IOException>(){
                        int counter = 0;

                        public void receive(String item) throws IOException {
                            if (this.counter++ % 1000 == 0) {
                                recordManager.commit();
                            }
                            String id = item.substring("{\"identity\":\"".length());
                            id = id.substring(0, id.indexOf(34));
                            byte[] stateArray = item.getBytes("UTF-8");
                            long stateIndex = recordManager.insert((Object)stateArray, JdbmEntityStoreMixin.this.serializer);
                            index.insert((Object)id.getBytes("UTF-8"), (Object)stateIndex, false);
                        }
                    });
                }
                catch (IOException e) {
                    recordManager.close();
                    tempDatabase.delete();
                    throw e;
                }
                catch (Throwable senderThrowableType) {
                    recordManager.close();
                    tempDatabase.delete();
                    throw senderThrowableType;
                }
                recordManager.commit();
                recordManager.close();
                JdbmEntityStoreMixin.this.lock.writeLock().lock();
                try {
                    JdbmEntityStoreMixin.this.recordManager.close();
                    boolean deletedOldDatabase = true;
                    deletedOldDatabase &= dbFile.delete();
                    if (!(deletedOldDatabase &= lgFile.delete())) {
                        throw new IOException("Could not remove old database");
                    }
                    boolean renamedTempDatabase = true;
                    renamedTempDatabase &= new File(tempDatabase.getAbsolutePath() + ".db").renameTo(dbFile);
                    if (!(renamedTempDatabase &= new File(tempDatabase.getAbsolutePath() + ".lg").renameTo(lgFile))) {
                        throw new IOException("Could not replace database with temp database");
                    }
                    JdbmEntityStoreMixin.this.initialize();
                }
                finally {
                    JdbmEntityStoreMixin.this.lock.writeLock().unlock();
                }
            }
        };
    }

    private String getDatabaseName() {
        String pathname = (String)((JdbmConfiguration)this.config.get()).file().get();
        if (pathname == null) {
            if (this.fileConfiguration != null) {
                File dataDir = this.fileConfiguration.dataDirectory();
                File jdbmDir = new File(dataDir, this.descriptor.identity() + "/jdbm.data");
                pathname = jdbmDir.getAbsolutePath();
            } else {
                pathname = System.getProperty("user.dir") + "/qi4j/jdbm.data";
            }
        }
        File dataFile = new File(pathname);
        File directory = dataFile.getAbsoluteFile().getParentFile();
        directory.mkdirs();
        String name = dataFile.getAbsolutePath();
        return name;
    }

    private Properties getProperties() {
        JdbmConfiguration config = (JdbmConfiguration)this.config.get();
        Properties properties = new Properties();
        properties.put("jdbm.autoCommit", ((Boolean)config.autoCommit().get()).toString());
        properties.put("jdbm.disableTransactions", ((Boolean)config.disableTransactions().get()).toString());
        return properties;
    }

    private Long getStateIndex(String identity) throws IOException {
        return (Long)this.index.find((Object)identity.getBytes("UTF-8"));
    }

    private void initialize() throws IOException {
        String name = this.getDatabaseName();
        Properties properties = this.getProperties();
        this.recordManager = RecordManagerFactory.createRecordManager((String)name, (Properties)properties);
        this.serializer = DefaultSerializer.INSTANCE;
        this.recordManager = new CacheRecordManager(this.recordManager, 1000, false);
        long recid = this.recordManager.getNamedObject("index");
        if (recid != 0L) {
            this.index = BTree.load((RecordManager)this.recordManager, (long)recid);
        } else {
            ByteArrayComparator comparator = new ByteArrayComparator();
            this.index = BTree.createInstance((RecordManager)this.recordManager, (Comparator)comparator, (Serializer)this.serializer, (Serializer)DefaultSerializer.INSTANCE, (int)16);
            this.recordManager.setNamedObject("index", this.index.getRecid());
        }
        this.recordManager.commit();
    }
}

