/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.client;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Tag;

public class ClientCache {
    Map<String, CacheInfo> identityToTimestamp = new HashMap<String, CacheInfo>();
    Map<String, String> pathToIdentity = new HashMap<String, String>();

    public void updateCache(Response response) {
        Tag tag;
        if (response.getRequest().getMethod().equals((Object)Method.DELETE)) {
            String path = this.getIdentityPath(response.getRequest().getResourceRef());
            String id = this.pathToIdentity.get(path);
            if (id != null) {
                this.identityToTimestamp.remove(id);
                Iterator<Map.Entry<String, String>> paths = this.pathToIdentity.entrySet().iterator();
                while (paths.hasNext()) {
                    Map.Entry<String, String> entry = paths.next();
                    if (!entry.getValue().equals(id)) continue;
                    paths.remove();
                }
            }
        } else if ((response.getRequest().getMethod().equals((Object)Method.PUT) || response.getRequest().getMethod().equals((Object)Method.POST)) && (tag = response.getEntity().getTag()) != null) {
            Reference ref = response.getRequest().getResourceRef().clone();
            CacheInfo value = new CacheInfo(response.getEntity().getModificationDate(), tag, ref);
            this.identityToTimestamp.put(value.getEntity(), value);
            String path = this.getIdentityPath(ref);
            this.pathToIdentity.put(path, value.getEntity());
        }
    }

    public void updateQueryConditions(Request request) {
        CacheInfo cacheInfo;
        String identity = this.pathToIdentity.get(this.getIdentityPath(request.getResourceRef()));
        if (identity != null && (cacheInfo = this.identityToTimestamp.get(identity)) != null) {
            request.getConditions().setModifiedSince(cacheInfo.getLastModified());
        }
    }

    public void updateCommandConditions(Request request) {
        CacheInfo cacheInfo;
        String identity = this.pathToIdentity.get(this.getIdentityPath(request.getResourceRef()));
        if (identity != null && (cacheInfo = this.identityToTimestamp.get(identity)) != null) {
            request.getConditions().setUnmodifiedSince(cacheInfo.getLastModified());
        }
    }

    private String getIdentityPath(Reference ref) {
        String path = ref.getPath();
        if (!path.endsWith("/")) {
            path = path.substring(0, path.lastIndexOf(47) + 1);
        }
        return path;
    }

    static class CacheInfo {
        private Reference ref;
        private Date lastModified;
        private Tag tag;
        private String entity;

        CacheInfo(Date lastModified, Tag tag, Reference ref) {
            this.lastModified = lastModified;
            this.tag = tag;
            this.ref = ref;
            this.entity = tag.getName().split("/")[0];
        }

        public Reference getRef() {
            return this.ref;
        }

        public Date getLastModified() {
            return this.lastModified;
        }

        public Tag getTag() {
            return this.tag;
        }

        public String getEntity() {
            return this.entity;
        }
    }
}

