/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.client;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Initializable;
import org.qi4j.api.mixin.InitializationException;
import org.qi4j.api.structure.Module;
import org.qi4j.library.rest.client.spi.RequestWriter;
import org.restlet.Request;
import org.restlet.data.Method;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestWriterDelegator
implements RequestWriter,
Initializable {
    List<RequestWriter> requestWriters = new ArrayList<RequestWriter>();
    @Structure
    private Module module;

    public void initialize() throws InitializationException {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        ResourceBundle defaultRequestWriters = ResourceBundle.getBundle("org.qi4j.library.rest.client.rest-client");
        String requestWriterClasses = defaultRequestWriters.getString("requestwriters");
        logger.info("Using request writers:" + requestWriterClasses);
        for (String className : requestWriterClasses.split(",")) {
            try {
                Class<?> writerClass = this.module.classLoader().loadClass(className.trim());
                RequestWriter requestWriter = (RequestWriter)this.module.newObject(writerClass, new Object[0]);
                this.registerRequestWriter(requestWriter);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Could not register request writer " + className, (Throwable)e);
            }
        }
    }

    public void registerRequestWriter(RequestWriter writer) {
        this.requestWriters.add(writer);
    }

    @Override
    public boolean writeRequest(Object requestObject, Request request) throws ResourceException {
        if (requestObject == null) {
            if (!Method.GET.equals((Object)request.getMethod())) {
                request.setEntity((Representation)new EmptyRepresentation());
            }
            return true;
        }
        if (requestObject instanceof Representation) {
            request.setEntity((Representation)requestObject);
            return true;
        }
        for (RequestWriter requestWriter : this.requestWriters) {
            if (!requestWriter.writeRequest(requestObject, request)) continue;
            return true;
        }
        return false;
    }
}

