/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.client.api;

import java.util.ArrayList;
import org.qi4j.api.common.Optional;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.library.rest.client.ClientCache;
import org.qi4j.library.rest.client.RequestWriterDelegator;
import org.qi4j.library.rest.client.ResponseReaderDelegator;
import org.qi4j.library.rest.client.api.ContextResourceClient;
import org.qi4j.library.rest.client.spi.RequestWriter;
import org.qi4j.library.rest.client.spi.ResponseHandler;
import org.qi4j.library.rest.client.spi.ResponseReader;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.ClientInfo;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.data.Reference;

public class ContextResourceClientFactory {
    @Structure
    private Module module;
    @Uses
    @Optional
    private ClientCache cache;
    @Uses
    private ResponseReaderDelegator readerDelegator;
    @Uses
    private RequestWriterDelegator requestWriterDelegator;
    @Uses
    private Uniform client;
    private ClientInfo info = new ClientInfo();
    private Form requestHeaders = new Form();
    private ResponseHandler errorHandler;

    public ContextResourceClient newClient(Reference reference) {
        ContextResourceClient contextResourceClient = (ContextResourceClient)this.module.newObject(ContextResourceClient.class, new Object[]{this, reference});
        contextResourceClient.onError(this.errorHandler);
        return contextResourceClient;
    }

    public void setAgent(String agent) {
        this.info.setAgent(agent);
    }

    public Form getCustomRequestHeaders() {
        return this.requestHeaders;
    }

    public void setAcceptedLanguages(Language ... acceptedLanguages) {
        ArrayList<Preference> languages = new ArrayList<Preference>();
        for (Language acceptedLanguage : acceptedLanguages) {
            languages.add(new Preference());
        }
        this.info.setAcceptedLanguages(languages);
    }

    public void setAcceptedMediaTypes(MediaType ... acceptedMediaTypes) {
        ArrayList<Preference> mediatypes = new ArrayList<Preference>();
        for (MediaType mediaType : acceptedMediaTypes) {
            mediatypes.add(new Preference((Metadata)mediaType));
        }
        this.info.setAcceptedMediaTypes(mediatypes);
    }

    public ClientInfo getInfo() {
        return this.info;
    }

    public void setErrorHandler(ResponseHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ResponseHandler getErrorHandler() {
        return this.errorHandler;
    }

    void updateCommandRequest(Request request) {
        request.setClientInfo(this.info);
        if (this.cache != null) {
            this.cache.updateCommandConditions(request);
        }
        if (!this.requestHeaders.isEmpty()) {
            request.getAttributes().put("org.restlet.http.headers", this.requestHeaders);
        }
    }

    void updateQueryRequest(Request request) {
        request.setClientInfo(this.info);
        if (this.cache != null) {
            this.cache.updateQueryConditions(request);
        }
    }

    void updateCache(Response response) {
        if (this.cache != null) {
            this.cache.updateCache(response);
        }
    }

    Uniform getClient() {
        return this.client;
    }

    public <T> T readResponse(Response response, Class<T> queryResult) {
        return (T)this.readerDelegator.readResponse(response, queryResult);
    }

    public void writeRequest(Request request, Object queryRequest) {
        if (!this.requestWriterDelegator.writeRequest(queryRequest, request)) {
            throw new IllegalArgumentException("Illegal query request type:" + queryRequest.getClass().getName());
        }
    }

    public void registerResponseReader(ResponseReader reader) {
        this.readerDelegator.registerResponseReader(reader);
    }

    public void registerRequestWriter(RequestWriter writer) {
        this.requestWriterDelegator.registerRequestWriter(writer);
    }
}

