/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.client.api;

import java.lang.reflect.ParameterizedType;
import org.qi4j.api.util.Classes;
import org.qi4j.library.rest.client.api.ContextResourceClient;
import org.qi4j.library.rest.client.spi.ResponseHandler;
import org.qi4j.library.rest.client.spi.ResultHandler;
import org.qi4j.library.rest.common.link.Link;
import org.restlet.Response;

public abstract class HandlerCommand {
    protected ResponseHandler responseHandler;
    protected ResponseHandler processingErrorHandler;

    public static HandlerCommand refresh() {
        return new RefreshCommand();
    }

    public static HandlerCommand query(String relation) {
        return new QueryCommand(relation, null);
    }

    public static HandlerCommand query(String relation, Object requestObject) {
        return new QueryCommand(relation, requestObject);
    }

    public static HandlerCommand query(Link relation) {
        return new QueryLinkCommand(relation);
    }

    public static HandlerCommand command(String relation) {
        return new CommandRelationCommand(relation, null);
    }

    public static HandlerCommand command(String relation, Object requestObject) {
        return new CommandRelationCommand(relation, requestObject);
    }

    public static HandlerCommand command(Link link) {
        return new CommandLinkCommand(link, null);
    }

    public static HandlerCommand command(Link link, Object requestObject) {
        return new CommandLinkCommand(link, requestObject);
    }

    public static HandlerCommand delete() {
        return new DeleteCommand();
    }

    public HandlerCommand onSuccess(ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
        return this;
    }

    public <T> HandlerCommand onSuccess(final ResultHandler<T> resultHandler) {
        final Class resultType = (Class)Classes.RAW_CLASS.map((Object)((ParameterizedType)resultHandler.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0]);
        this.responseHandler = new ResponseHandler(){

            @Override
            public HandlerCommand handleResponse(Response response, ContextResourceClient client) {
                Object result = client.getContextResourceClientFactory().readResponse(response, resultType);
                return resultHandler.handleResult(result, client);
            }
        };
        return this;
    }

    public HandlerCommand onProcessingError(ResponseHandler processingErrorHandler) {
        this.processingErrorHandler = processingErrorHandler;
        return this;
    }

    public <T> HandlerCommand onProcessingError(final ResultHandler<T> resultHandler) {
        final Class resultType = (Class)Classes.RAW_CLASS.map((Object)((ParameterizedType)resultHandler.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0]);
        this.processingErrorHandler = new ResponseHandler(){

            @Override
            public HandlerCommand handleResponse(Response response, ContextResourceClient client) {
                Object result = client.getContextResourceClientFactory().readResponse(response, resultType);
                return resultHandler.handleResult(result, client);
            }
        };
        return this;
    }

    abstract HandlerCommand execute(ContextResourceClient var1);

    private static class DeleteCommand
    extends HandlerCommand {
        private DeleteCommand() {
        }

        @Override
        HandlerCommand execute(ContextResourceClient client) {
            return client.delete(this.responseHandler, this.processingErrorHandler);
        }
    }

    private static class CommandLinkCommand
    extends HandlerCommand {
        private Link link;
        private Object requestObject;

        private CommandLinkCommand(Link link, Object requestObject) {
            this.link = link;
            this.requestObject = requestObject;
        }

        @Override
        HandlerCommand execute(ContextResourceClient client) {
            return client.command(this.link, this.requestObject, this.responseHandler, this.processingErrorHandler);
        }
    }

    private static class CommandRelationCommand
    extends HandlerCommand {
        private String relation;
        private Object requestObject;

        private CommandRelationCommand(String relation, Object requestObject) {
            this.relation = relation;
            this.requestObject = requestObject;
        }

        @Override
        HandlerCommand execute(ContextResourceClient client) {
            return client.command(client.getResource().command(this.relation), this.requestObject, this.responseHandler, this.processingErrorHandler);
        }
    }

    private static class QueryLinkCommand
    extends HandlerCommand {
        private Link link;

        private QueryLinkCommand(Link link) {
            this.link = link;
        }

        @Override
        HandlerCommand execute(ContextResourceClient client) {
            return client.query(this.link, null, this.responseHandler, this.processingErrorHandler);
        }
    }

    private static class QueryCommand
    extends HandlerCommand {
        private String relation;
        private Object requestObject;

        private QueryCommand(String relation, Object requestObject) {
            this.relation = relation;
            this.requestObject = requestObject;
        }

        @Override
        HandlerCommand execute(ContextResourceClient client) {
            return client.query(client.getResource().query(this.relation), this.requestObject, this.responseHandler, this.processingErrorHandler);
        }
    }

    private static class RefreshCommand
    extends HandlerCommand {
        private RefreshCommand() {
        }

        @Override
        HandlerCommand execute(ContextResourceClient client) {
            return client.refresh();
        }
    }
}

