/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.client.responsereader;

import java.io.IOException;
import org.json.JSONException;
import org.json.JSONTokener;
import org.qi4j.library.rest.client.spi.ResponseReader;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.resource.ResourceException;

public class DefaultResponseReader
implements ResponseReader {
    @Override
    public Object readResponse(Response response, Class<?> resultType) throws ResourceException {
        if (MediaType.APPLICATION_JSON.equals((Object)response.getEntity().getMediaType())) {
            if (resultType.equals(String.class)) {
                try {
                    return response.getEntity().getText();
                }
                catch (IOException e) {
                    throw new ResourceException((Throwable)e);
                }
            }
            if (Number.class.isAssignableFrom(resultType)) {
                try {
                    Number value = (Number)new JSONTokener(response.getEntityAsText()).nextValue();
                    if (resultType.equals(Integer.class)) {
                        return value.intValue();
                    }
                }
                catch (JSONException e) {
                    throw new ResourceException((Throwable)e);
                }
            }
        }
        return null;
    }
}

