/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.client.responsereader;

import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.service.qualifier.Tagged;
import org.qi4j.api.structure.Module;
import org.qi4j.api.type.ValueCompositeType;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.api.value.ValueDeserializer;
import org.qi4j.library.rest.client.spi.ResponseReader;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.resource.ResourceException;

public class JSONResponseReader
implements ResponseReader {
    @Structure
    private Module module;
    @Service
    @Tagged(value={"json"})
    private ValueDeserializer valueDeserializer;

    @Override
    public Object readResponse(Response response, Class<?> resultType) {
        if (response.getEntity().getMediaType().equals((Object)MediaType.APPLICATION_JSON)) {
            if (ValueComposite.class.isAssignableFrom(resultType)) {
                String jsonValue = response.getEntityAsText();
                ValueCompositeType valueType = this.module.valueDescriptor(resultType.getName()).valueType();
                return this.valueDeserializer.deserialize((ValueType)valueType, jsonValue);
            }
            if (resultType.equals(Form.class)) {
                try {
                    String jsonValue = response.getEntityAsText();
                    JSONObject jsonObject = new JSONObject(jsonValue);
                    Iterator keys = jsonObject.keys();
                    Form form = new Form();
                    while (keys.hasNext()) {
                        Object key = keys.next();
                        form.set(key.toString(), jsonObject.get(key.toString()).toString());
                    }
                    return form;
                }
                catch (JSONException e) {
                    throw new ResourceException((Throwable)e);
                }
            }
        }
        return null;
    }
}

