/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.migration;

import java.util.ArrayList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Application;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.migration.MigrationConfiguration;
import org.qi4j.migration.MigrationEvents;
import org.qi4j.migration.Migrator;
import org.qi4j.migration.assembly.EntityMigrationRule;
import org.qi4j.migration.assembly.MigrationBuilder;
import org.qi4j.migration.assembly.MigrationRule;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.entitystore.helpers.Migration;
import org.qi4j.spi.entitystore.helpers.StateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={MigrationMixin.class})
@Activators(value={Activator.class})
public interface MigrationService
extends Migration {
    public void initialize() throws Exception;

    public static class MigrationMixin
    implements MigrationService,
    Migrator {
        @Structure
        Application app;
        @This
        Configuration<MigrationConfiguration> config;
        @Uses
        ServiceDescriptor descriptor;
        @Service
        StateStore store;
        @Service
        EntityStore entityStore;
        @Structure
        UnitOfWorkFactory uowf;
        @This
        Migrator migrator;
        public MigrationBuilder builder;
        public Logger log;
        @Service
        Iterable<MigrationEvents> migrationEvents;

        public boolean migrate(JSONObject state, String toVersion, StateStore stateStore) throws JSONException {
            String fromVersion = state.optString("application_version", "0.0");
            Iterable<EntityMigrationRule> matchedRules = this.builder.entityMigrationRules().rulesBetweenVersions(fromVersion, toVersion);
            boolean changed = false;
            if (matchedRules != null) {
                for (EntityMigrationRule matchedRule : matchedRules) {
                    boolean ruleExecuted = matchedRule.upgrade(state, stateStore, this.migrator);
                    if (ruleExecuted && this.log.isDebugEnabled()) {
                        this.log.debug(matchedRule.toString());
                    }
                    changed = ruleExecuted || changed;
                }
            }
            state.put("application_version", (Object)toVersion);
            if (changed) {
                this.log.info("Migrated " + state.getString("identity") + " from " + fromVersion + " to " + toVersion);
            }
            return changed;
        }

        @Override
        public void initialize() throws Exception {
            this.builder = (MigrationBuilder)this.descriptor.metaInfo(MigrationBuilder.class);
            this.log = LoggerFactory.getLogger(MigrationService.class);
            String version = this.app.version();
            String lastVersion = (String)((MigrationConfiguration)this.config.get()).lastStartupVersion().get();
            if (!this.app.version().equals(lastVersion)) {
                Iterable<MigrationRule> rules = this.builder.migrationRules().rulesBetweenVersions(lastVersion, version);
                ArrayList<MigrationRule> executedRules = new ArrayList<MigrationRule>();
                try {
                    if (rules != null) {
                        for (MigrationRule rule : rules) {
                            rule.upgrade(this.store, this);
                            executedRules.add(rule);
                            this.log.debug(rule.toString());
                        }
                        this.log.info("Migrated to " + version);
                    }
                    ((MigrationConfiguration)this.config.get()).lastStartupVersion().set((Object)version);
                    this.config.save();
                }
                catch (Exception e) {
                    this.log.error("Upgrade failed", (Throwable)e);
                    for (MigrationRule executedRule : executedRules) {
                        executedRule.downgrade(this.store, this);
                    }
                }
            }
        }

        @Override
        public boolean addProperty(JSONObject state, String name, Object defaultValue) throws JSONException {
            JSONObject properties = state.getJSONObject("properties");
            if (!properties.has(name)) {
                if (defaultValue == null) {
                    properties.put(name, JSONObject.NULL);
                } else {
                    properties.put(name, defaultValue);
                }
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.propertyAdded(state.getString("identity"), name, defaultValue);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean removeProperty(JSONObject state, String name) throws JSONException {
            JSONObject properties = state.getJSONObject("properties");
            if (properties.has(name)) {
                properties.remove(name);
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.propertyRemoved(state.getString("identity"), name);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean renameProperty(JSONObject state, String from, String to) throws JSONException {
            JSONObject properties = state.getJSONObject("properties");
            if (properties.has(from)) {
                Object value = properties.remove(from);
                properties.put(to, value);
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.propertyRenamed(state.getString("identity"), from, to);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean addAssociation(JSONObject state, String name, String defaultReference) throws JSONException {
            JSONObject associations = state.getJSONObject("associations");
            if (!associations.has(name)) {
                if (defaultReference == null) {
                    associations.put(name, JSONObject.NULL);
                } else {
                    associations.put(name, (Object)defaultReference);
                }
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.associationAdded(state.getString("identity"), name, defaultReference);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAssociation(JSONObject state, String name) throws JSONException {
            JSONObject associations = state.getJSONObject("associations");
            if (associations.has(name)) {
                associations.remove(name);
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.associationRemoved(state.getString("identity"), name);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean renameAssociation(JSONObject state, String from, String to) throws JSONException {
            JSONObject associations = state.getJSONObject("associations");
            if (associations.has(from)) {
                Object value = associations.remove(from);
                associations.put(to, value);
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.associationRenamed(state.getString("identity"), from, to);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean addManyAssociation(JSONObject state, String name, String ... defaultReferences) throws JSONException {
            JSONObject manyAssociations = state.getJSONObject("manyassociations");
            if (!manyAssociations.has(name)) {
                JSONArray references = new JSONArray();
                for (String reference : defaultReferences) {
                    references.put((Object)reference);
                }
                manyAssociations.put(name, (Object)references);
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.manyAssociationAdded(state.getString("identity"), name, defaultReferences);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean removeManyAssociation(JSONObject state, String name) throws JSONException {
            JSONObject manyAssociations = state.getJSONObject("manyassociations");
            if (manyAssociations.has(name)) {
                manyAssociations.remove(name);
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.manyAssociationRemoved(state.getString("identity"), name);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean renameManyAssociation(JSONObject state, String from, String to) throws JSONException {
            JSONObject manyAssociations = state.getJSONObject("manyassociations");
            if (manyAssociations.has(from)) {
                Object value = manyAssociations.remove(from);
                manyAssociations.put(to, value);
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.manyAssociationRenamed(state.getString("identity"), from, to);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean addNamedAssociation(JSONObject state, String name, Map<String, String> defaultReferences) throws JSONException {
            JSONObject namedAssociations = state.getJSONObject("namedassociations");
            if (!namedAssociations.has(name)) {
                JSONObject references = new JSONObject();
                for (Map.Entry<String, String> namedRef : defaultReferences.entrySet()) {
                    references.put(namedRef.getKey(), (Object)namedRef.getValue());
                }
                namedAssociations.put(name, (Object)references);
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.namedAssociationAdded(state.getString("identity"), name, defaultReferences);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean removeNamedAssociation(JSONObject state, String name) throws JSONException {
            JSONObject namedAssociations = state.getJSONObject("namedassociations");
            if (namedAssociations.has(name)) {
                namedAssociations.remove(name);
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.namedAssociationRemoved(state.getString("identity"), name);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean renameNamedAssociation(JSONObject state, String from, String to) throws JSONException {
            JSONObject namedAssociations = state.getJSONObject("namedassociations");
            if (namedAssociations.has(from)) {
                Object value = namedAssociations.remove(from);
                namedAssociations.put(to, value);
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.namedAssociationRenamed(state.getString("identity"), from, to);
                }
                return true;
            }
            return false;
        }

        @Override
        public void changeEntityType(JSONObject state, String newEntityType) throws JSONException {
            state.put("type", (Object)newEntityType);
            for (MigrationEvents migrationEvent : this.migrationEvents) {
                migrationEvent.entityTypeChanged(state.getString("identity"), newEntityType);
            }
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<MigrationService>> {
        public void afterActivation(ServiceReference<MigrationService> activated) throws Exception {
            ((MigrationService)activated.get()).initialize();
        }
    }
}

