/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.migration.assembly;

import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.migration.Migrator;
import org.qi4j.migration.assembly.AbstractMigrationRule;
import org.qi4j.migration.assembly.EntityMigrationOperation;
import org.qi4j.spi.entitystore.helpers.StateStore;

public class EntityMigrationRule
extends AbstractMigrationRule {
    private final String[] entityTypes;
    private final EntityMigrationOperation operationEntity;

    public EntityMigrationRule(String fromVersion, String toVersion, String[] entityTypes, EntityMigrationOperation operationEntity) {
        super(fromVersion, toVersion);
        this.entityTypes = entityTypes;
        this.operationEntity = operationEntity;
    }

    public String[] entityTypes() {
        return this.entityTypes;
    }

    public boolean upgrade(JSONObject state, StateStore stateStore, Migrator migrator) throws JSONException {
        if (this.appliesTo(state.getString("type"))) {
            return this.operationEntity.upgrade(state, stateStore, migrator);
        }
        return false;
    }

    public boolean downgrade(JSONObject state, StateStore stateStore, Migrator migrator) throws JSONException {
        if (this.appliesTo(state.getString("type"))) {
            return this.operationEntity.downgrade(state, stateStore, migrator);
        }
        return false;
    }

    public boolean appliesTo(String entityType) {
        for (String type : this.entityTypes) {
            if (!entityType.equals(type)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.fromVersion + "->" + this.toVersion + ": on " + Arrays.asList(this.entityTypes) + " do " + this.operationEntity;
    }
}

