/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.tools.model.util;

import java.util.ArrayList;
import java.util.List;
import org.qi4j.tools.model.descriptor.ApplicationDetailDescriptor;
import org.qi4j.tools.model.descriptor.EntityDetailDescriptor;
import org.qi4j.tools.model.descriptor.InjectedFieldDetailDescriptor;
import org.qi4j.tools.model.descriptor.LayerDetailDescriptor;
import org.qi4j.tools.model.descriptor.MixinDetailDescriptor;
import org.qi4j.tools.model.descriptor.ModuleDetailDescriptor;
import org.qi4j.tools.model.descriptor.ObjectDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.TransientDetailDescriptor;
import org.qi4j.tools.model.descriptor.ValueDetailDescriptor;

class SPIFinder {
    private ApplicationDetailDescriptor appDetailDescriptor;

    SPIFinder() {
    }

    public List<ServiceDetailDescriptor> findModule(ModuleDetailDescriptor descriptor) {
        this.appDetailDescriptor = descriptor.layer().application();
        ArrayList<ServiceDetailDescriptor> list = new ArrayList<ServiceDetailDescriptor>();
        this.findInServices(descriptor.services(), list);
        this.findInEntities(descriptor.entities(), list);
        this.findInValues(descriptor.values(), list);
        this.findInTransients(descriptor.transients(), list);
        this.findInObjects(descriptor.objects(), list);
        return list;
    }

    public List<ServiceDetailDescriptor> findLayerSPI(LayerDetailDescriptor descriptor) {
        ArrayList<ServiceDetailDescriptor> list = new ArrayList<ServiceDetailDescriptor>();
        for (ModuleDetailDescriptor moduleDetailDescriptor : descriptor.modules()) {
            list.addAll(this.findModule(moduleDetailDescriptor));
        }
        return list;
    }

    private void findInMixin(Iterable<MixinDetailDescriptor> iter, ArrayList<ServiceDetailDescriptor> list) {
        for (MixinDetailDescriptor descriptor : iter) {
            this.findInInjectedField(descriptor.injectedFields(), list);
        }
    }

    private void findInInjectedField(Iterable<InjectedFieldDetailDescriptor> iter, ArrayList<ServiceDetailDescriptor> list) {
    }

    private void findInServices(Iterable<ServiceDetailDescriptor> iter, ArrayList<ServiceDetailDescriptor> list) {
        for (ServiceDetailDescriptor descriptor : iter) {
            this.findInMixin(descriptor.mixins(), list);
        }
    }

    private void findInEntities(Iterable<EntityDetailDescriptor> iter, ArrayList<ServiceDetailDescriptor> list) {
        for (EntityDetailDescriptor descriptor : iter) {
            this.findInMixin(descriptor.mixins(), list);
        }
    }

    private void findInValues(Iterable<ValueDetailDescriptor> iter, ArrayList<ServiceDetailDescriptor> list) {
        for (ValueDetailDescriptor descriptor : iter) {
            this.findInMixin(descriptor.mixins(), list);
        }
    }

    private void findInTransients(Iterable<TransientDetailDescriptor> iter, ArrayList<ServiceDetailDescriptor> list) {
        for (TransientDetailDescriptor descriptor : iter) {
            this.findInMixin(descriptor.mixins(), list);
        }
    }

    private void findInObjects(Iterable<ObjectDetailDescriptor> iter, ArrayList<ServiceDetailDescriptor> list) {
        for (ObjectDetailDescriptor descriptor : iter) {
            this.findInInjectedField(descriptor.injectedFields(), list);
        }
    }

    private ServiceDetailDescriptor lookupServiceDetailDescriptor(String name) {
        ServiceDetailDescriptor serviceDetailDescriptor = null;
        for (LayerDetailDescriptor layer : this.appDetailDescriptor.layers()) {
            for (ModuleDetailDescriptor module : layer.modules()) {
                for (ServiceDetailDescriptor service : module.services()) {
                    if (!service.toString().equals(name)) continue;
                    serviceDetailDescriptor = service;
                    break;
                }
                if (serviceDetailDescriptor == null) continue;
                break;
            }
            if (serviceDetailDescriptor == null) continue;
            break;
        }
        return serviceDetailDescriptor;
    }
}

