/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.tools.model.util;

import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.functional.Iterables;
import org.qi4j.tools.model.descriptor.ApplicationDetailDescriptor;
import org.qi4j.tools.model.descriptor.CompositeDetailDescriptor;
import org.qi4j.tools.model.descriptor.EntityDetailDescriptor;
import org.qi4j.tools.model.descriptor.LayerDetailDescriptor;
import org.qi4j.tools.model.descriptor.ModuleDetailDescriptor;
import org.qi4j.tools.model.descriptor.ObjectDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.TransientDetailDescriptor;
import org.qi4j.tools.model.descriptor.ValueDetailDescriptor;

class ServiceConfigurationFinder {
    ServiceConfigurationFinder() {
    }

    public Object findConfigurationDescriptor(ServiceDetailDescriptor descriptor) {
        Class configType = ((ServiceDescriptor)descriptor.descriptor()).configurationType();
        if (configType == null) {
            return null;
        }
        ApplicationDetailDescriptor appDescriptor = descriptor.module().layer().application();
        Object obj = this.findConfigurationDescriptor(appDescriptor, configType);
        if (obj == null) {
            return null;
        }
        return obj;
    }

    private Object findConfigurationDescriptor(ApplicationDetailDescriptor descriptor, Class<?> configType) {
        Object configDescriptor = null;
        for (LayerDetailDescriptor childDescriptor : descriptor.layers()) {
            Object obj = this.findInModules(childDescriptor.modules(), configType);
            if (obj == null) continue;
            configDescriptor = obj;
            break;
        }
        return configDescriptor;
    }

    private Object findInModules(Iterable<ModuleDetailDescriptor> iter, Class<?> configType) {
        Object configDescriptor = null;
        for (ModuleDetailDescriptor descriptor : iter) {
            Object obj = this.findInTypes(descriptor.services(), configType);
            if (obj != null) {
                configDescriptor = obj;
                break;
            }
            obj = this.findInTypes(descriptor.entities(), configType);
            if (obj != null) {
                configDescriptor = obj;
                break;
            }
            obj = this.findInTypes(descriptor.transients(), configType);
            if (obj != null) {
                configDescriptor = obj;
                break;
            }
            obj = this.findInTypes(descriptor.values(), configType);
            if (obj != null) {
                configDescriptor = obj;
                break;
            }
            obj = this.findInTypes(descriptor.objects(), configType);
            if (obj == null) continue;
            configDescriptor = obj;
            break;
        }
        return configDescriptor;
    }

    private Object findInTypes(Iterable iter, Class<?> configType) {
        Object configDescriptor = null;
        for (Object obj : iter) {
            Object descriptor = obj instanceof ServiceDetailDescriptor ? ((ServiceDetailDescriptor)obj).descriptor() : (obj instanceof EntityDetailDescriptor ? ((EntityDetailDescriptor)obj).descriptor() : (obj instanceof ValueDetailDescriptor ? ((ValueDetailDescriptor)obj).descriptor() : (obj instanceof ObjectDetailDescriptor ? ((ObjectDetailDescriptor)obj).descriptor() : (obj instanceof TransientDetailDescriptor ? ((TransientDetailDescriptor)obj).descriptor() : ((CompositeDetailDescriptor)obj).descriptor()))));
            if (!configType.equals(Iterables.first((Iterable)descriptor.types()))) continue;
            configDescriptor = obj;
            break;
        }
        return configDescriptor;
    }
}

