/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.tools.model.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.property.Property;
import org.qi4j.functional.Iterables;
import org.qi4j.tools.model.descriptor.CompositeDetailDescriptor;
import org.qi4j.tools.model.descriptor.CompositeMethodDetailDescriptor;

public class StateFinder {
    public List<CompositeMethodDetailDescriptor> findState(CompositeDetailDescriptor<?> descriptor) {
        return this.findState(descriptor.methods());
    }

    private List<CompositeMethodDetailDescriptor> findState(Iterable<CompositeMethodDetailDescriptor> iter) {
        ArrayList<CompositeMethodDetailDescriptor> publicList = new ArrayList<CompositeMethodDetailDescriptor>();
        ArrayList<CompositeMethodDetailDescriptor> privateList = new ArrayList<CompositeMethodDetailDescriptor>();
        for (CompositeMethodDetailDescriptor descriptor : iter) {
            Class compositeClass = (Class)Iterables.first((Iterable)descriptor.composite().descriptor().types());
            Class<?> mixinMethodClass = descriptor.descriptor().method().getDeclaringClass();
            if (mixinMethodClass.isAssignableFrom(compositeClass)) {
                publicList.add(descriptor);
                continue;
            }
            privateList.add(descriptor);
        }
        publicList.addAll(privateList);
        this.doFilter(publicList);
        return publicList;
    }

    private void doFilter(List<CompositeMethodDetailDescriptor> list) {
        if (list.isEmpty()) {
            return;
        }
        Iterator<CompositeMethodDetailDescriptor> iter = list.iterator();
        while (iter.hasNext()) {
            CompositeMethodDetailDescriptor descriptor = iter.next();
            Method method = descriptor.descriptor().method();
            if (Property.class.isAssignableFrom(method.getReturnType()) || Association.class.isAssignableFrom(method.getReturnType()) || ManyAssociation.class.isAssignableFrom(method.getReturnType()) || NamedAssociation.class.isAssignableFrom(method.getReturnType())) continue;
            iter.remove();
        }
    }
}

