/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.sql;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.JSONWriter;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.cache.CacheOptions;
import org.qi4j.api.common.Optional;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.service.ServiceActivation;
import org.qi4j.api.service.qualifier.Tagged;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.Module;
import org.qi4j.api.type.ValueType;
import org.qi4j.api.unitofwork.EntityTypeNotFoundException;
import org.qi4j.api.usecase.Usecase;
import org.qi4j.api.usecase.UsecaseBuilder;
import org.qi4j.api.value.ValueSerialization;
import org.qi4j.entitystore.sql.internal.DatabaseSQLService;
import org.qi4j.entitystore.sql.internal.SQLEntityState;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Visitor;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.library.sql.common.SQLUtil;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entitystore.DefaultEntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.EntityNotFoundException;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.EntityStoreSPI;
import org.qi4j.spi.entitystore.EntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.ModuleEntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.StateCommitter;
import org.qi4j.spi.entitystore.helpers.DefaultEntityState;
import org.qi4j.spi.entitystore.helpers.Migration;
import org.qi4j.spi.entitystore.helpers.StateStore;
import org.qi4j.spi.module.ModelModule;
import org.qi4j.spi.module.ModuleSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLEntityStoreMixin
implements EntityStore,
EntityStoreSPI,
StateStore,
ServiceActivation {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLEntityStoreMixin.class);
    @Service
    private DatabaseSQLService database;
    @This
    private EntityStoreSPI entityStoreSPI;
    @Structure
    private Qi4jSPI spi;
    @Structure
    private Application application;
    @Service
    @Tagged(value={"json"})
    private ValueSerialization valueSerialization;
    @Optional
    @Service
    private Migration migration;
    private String uuid;
    private final AtomicInteger count = new AtomicInteger();

    public void activateService() throws Exception {
        this.uuid = UUID.randomUUID().toString() + "-";
        this.count.set(0);
        this.database.startDatabase();
    }

    public void passivateService() throws Exception {
        this.database.stopDatabase();
    }

    public StateCommitter applyChanges(final EntityStoreUnitOfWork unitofwork, final Iterable<EntityState> states) {
        return new StateCommitter(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void commit() {
                Connection connection = null;
                PreparedStatement insertPS = null;
                PreparedStatement updatePS = null;
                PreparedStatement removePS = null;
                try {
                    connection = SQLEntityStoreMixin.this.database.getConnection();
                    connection.setAutoCommit(false);
                    insertPS = SQLEntityStoreMixin.this.database.prepareInsertEntityStatement(connection);
                    updatePS = SQLEntityStoreMixin.this.database.prepareUpdateEntityStatement(connection);
                    removePS = SQLEntityStoreMixin.this.database.prepareRemoveEntityStatement(connection);
                    for (EntityState state : states) {
                        EntityStatus status = state.status();
                        DefaultEntityState defState = ((SQLEntityState)state).getDefaultEntityState();
                        Long entityPK = ((SQLEntityState)state).getEntityPK();
                        if (EntityStatus.REMOVED.equals((Object)status)) {
                            SQLEntityStoreMixin.this.database.populateRemoveEntityStatement(removePS, entityPK, state.identity());
                            removePS.addBatch();
                            continue;
                        }
                        StringWriter writer = new StringWriter();
                        SQLEntityStoreMixin.this.writeEntityState(defState, writer, unitofwork.identity());
                        writer.flush();
                        if (EntityStatus.UPDATED.equals((Object)status)) {
                            Long entityOptimisticLock = ((SQLEntityState)state).getEntityOptimisticLock();
                            SQLEntityStoreMixin.this.database.populateUpdateEntityStatement(updatePS, entityPK, entityOptimisticLock, defState.identity(), writer.toString(), unitofwork.currentTime());
                            updatePS.addBatch();
                            continue;
                        }
                        if (!EntityStatus.NEW.equals((Object)status)) continue;
                        SQLEntityStoreMixin.this.database.populateInsertEntityStatement(insertPS, defState.identity(), writer.toString(), unitofwork.currentTime());
                        insertPS.addBatch();
                    }
                    removePS.executeBatch();
                    insertPS.executeBatch();
                    updatePS.executeBatch();
                    connection.commit();
                }
                catch (SQLException sqle) {
                    try {
                        SQLUtil.rollbackQuietly((Connection)connection);
                        if (!LOGGER.isDebugEnabled()) throw new EntityStoreException((Throwable)sqle);
                        StringWriter sb = new StringWriter();
                        sb.append("SQLException during commit, logging nested exceptions before throwing EntityStoreException:\n");
                        SQLException e = sqle;
                        while (true) {
                            if (e == null) {
                                LOGGER.debug(sb.toString());
                                throw new EntityStoreException((Throwable)sqle);
                            }
                            e.printStackTrace(new PrintWriter((Writer)sb, true));
                            e = e.getNextException();
                        }
                        catch (RuntimeException re) {
                            SQLUtil.rollbackQuietly(connection);
                            throw new EntityStoreException((Throwable)re);
                        }
                    }
                    catch (Throwable throwable) {
                        SQLUtil.closeQuietly(insertPS);
                        SQLUtil.closeQuietly(updatePS);
                        SQLUtil.closeQuietly(removePS);
                        SQLUtil.closeQuietly((Connection)connection);
                        throw throwable;
                    }
                }
                SQLUtil.closeQuietly((Statement)insertPS);
                SQLUtil.closeQuietly((Statement)updatePS);
                SQLUtil.closeQuietly((Statement)removePS);
                SQLUtil.closeQuietly((Connection)connection);
            }

            public void cancel() {
            }
        };
    }

    public EntityState entityStateOf(EntityStoreUnitOfWork unitOfWork, ModuleSpi module, EntityReference entityRef) {
        DatabaseSQLService.EntityValueResult valueResult = this.getValue(entityRef);
        DefaultEntityState state = this.readEntityState(module, valueResult.getReader());
        return new SQLEntityState.DefaultSQLEntityState(state, valueResult.getEntityPK(), valueResult.getEntityOptimisticLock());
    }

    public EntityState newEntityState(EntityStoreUnitOfWork unitOfWork, ModuleSpi module, EntityReference entityRef, EntityDescriptor entityDescriptor) {
        return new SQLEntityState.DefaultSQLEntityState(new DefaultEntityState(unitOfWork.currentTime(), entityRef, entityDescriptor));
    }

    public EntityStoreUnitOfWork newUnitOfWork(Usecase usecase, ModuleSpi module, long currentTime) {
        DefaultEntityStoreUnitOfWork storeUnitOfWork = new DefaultEntityStoreUnitOfWork(this.entityStoreSPI, this.newUnitOfWorkId(), usecase, currentTime);
        storeUnitOfWork = new ModuleEntityStoreUnitOfWork(module, (EntityStoreUnitOfWork)storeUnitOfWork);
        return storeUnitOfWork;
    }

    public Input<EntityState, EntityStoreException> entityStates(final ModuleSpi module) {
        return new Input<EntityState, EntityStoreException>(){

            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super EntityState, ReceiverThrowableType> output) throws EntityStoreException, ReceiverThrowableType {
                output.receiveFrom((Sender)new Sender<EntityState, EntityStoreException>(){

                    public <ReceiverThrowableType extends Throwable> void sendTo(final Receiver<? super EntityState, ReceiverThrowableType> receiver) throws ReceiverThrowableType, EntityStoreException {
                        SQLEntityStoreMixin.this.queryAllEntities(module, new EntityStatesVisitor(){

                            public boolean visit(EntityState visited) throws SQLException {
                                try {
                                    receiver.receive((Object)visited);
                                }
                                catch (Throwable receiverThrowableType) {
                                    throw new SQLException(receiverThrowableType);
                                }
                                return true;
                            }
                        });
                    }
                });
            }
        };
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void queryAllEntities(ModuleSpi module, EntityStatesVisitor entityStatesVisitor) {
        ResultSet rs;
        PreparedStatement ps;
        Connection connection;
        block7: {
            block6: {
                connection = null;
                ps = null;
                rs = null;
                UsecaseBuilder builder = UsecaseBuilder.buildUsecase((String)"qi4j.entitystore.sql.visit");
                Usecase usecase = builder.withMetaInfo((Object)CacheOptions.NEVER).newUsecase();
                ModuleEntityStoreUnitOfWork uow = (ModuleEntityStoreUnitOfWork)this.newUnitOfWork(usecase, module, System.currentTimeMillis());
                try {
                    connection = this.database.getConnection();
                    ps = this.database.prepareGetAllEntitiesStatement(connection);
                    this.database.populateGetAllEntitiesStatement(ps);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        DefaultEntityState entityState = this.readEntityState(module, this.database.getEntityValue(rs).getReader());
                        if (entityStatesVisitor.visit(entityState)) continue;
                        break block6;
                    }
                    break block7;
                }
                catch (SQLException ex) {
                    try {
                        throw new EntityStoreException((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        SQLUtil.closeQuietly(rs);
                        SQLUtil.closeQuietly(ps);
                        SQLUtil.closeQuietly((Connection)connection);
                        throw throwable;
                    }
                }
            }
            SQLUtil.closeQuietly((ResultSet)rs);
            SQLUtil.closeQuietly((Statement)ps);
            SQLUtil.closeQuietly((Connection)connection);
            return;
        }
        SQLUtil.closeQuietly((ResultSet)rs);
        SQLUtil.closeQuietly((Statement)ps);
        SQLUtil.closeQuietly((Connection)connection);
    }

    protected String newUnitOfWorkId() {
        return this.uuid + Integer.toHexString(this.count.incrementAndGet());
    }

    protected DefaultEntityState readEntityState(ModuleSpi module, Reader entityState) throws EntityStoreException {
        try {
            String type;
            EntityDescriptor entityDescriptor;
            JSONObject jsonObject = new JSONObject(new JSONTokener(entityState));
            EntityStatus status = EntityStatus.LOADED;
            String version = jsonObject.getString("version");
            long modified = jsonObject.getLong("modified");
            String identity = jsonObject.getString("identity");
            String currentAppVersion = jsonObject.optString("application_version", "0.0");
            if (!currentAppVersion.equals(this.application.version())) {
                if (this.migration != null) {
                    this.migration.migrate(jsonObject, this.application.version(), (StateStore)this);
                } else {
                    jsonObject.put("application_version", (Object)this.application.version());
                }
                LOGGER.trace("Updated version nr on {} from {} to {}", new Object[]{identity, currentAppVersion, this.application.version()});
                status = EntityStatus.UPDATED;
            }
            if ((entityDescriptor = module.entityDescriptor(type = jsonObject.getString("type"))) == null) {
                throw new EntityTypeNotFoundException(type, module.name(), Iterables.map((Function)ModelModule.toStringFunction, (Iterable)module.findVisibleEntityTypes()));
            }
            HashMap<QualifiedName, Object> properties = new HashMap<QualifiedName, Object>();
            JSONObject props = jsonObject.getJSONObject("properties");
            for (PropertyDescriptor propertyDescriptor : entityDescriptor.state().properties()) {
                Object jsonValue;
                try {
                    jsonValue = props.get(propertyDescriptor.qualifiedName().name());
                }
                catch (JSONException e) {
                    Object initialValue = propertyDescriptor.initialValue((Module)module);
                    properties.put(propertyDescriptor.qualifiedName(), initialValue);
                    status = EntityStatus.UPDATED;
                    continue;
                }
                if (JSONObject.NULL.equals(jsonValue)) {
                    properties.put(propertyDescriptor.qualifiedName(), null);
                    continue;
                }
                Object value = this.valueSerialization.deserialize(propertyDescriptor.valueType(), jsonValue.toString());
                properties.put(propertyDescriptor.qualifiedName(), value);
            }
            HashMap<QualifiedName, EntityReference> associations = new HashMap<QualifiedName, EntityReference>();
            JSONObject assocs = jsonObject.getJSONObject("associations");
            for (AssociationDescriptor associationType : entityDescriptor.state().associations()) {
                try {
                    Object jsonValue = assocs.get(associationType.qualifiedName().name());
                    EntityReference value = jsonValue == JSONObject.NULL ? null : EntityReference.parseEntityReference((String)((String)jsonValue));
                    associations.put(associationType.qualifiedName(), value);
                }
                catch (JSONException e) {
                    associations.put(associationType.qualifiedName(), null);
                    status = EntityStatus.UPDATED;
                }
            }
            JSONObject manyAssocs = jsonObject.getJSONObject("manyassociations");
            HashMap manyAssociations = new HashMap();
            for (AssociationDescriptor manyAssociationType : entityDescriptor.state().manyAssociations()) {
                ArrayList<EntityReference> references = new ArrayList<EntityReference>();
                try {
                    JSONArray jsonValues = manyAssocs.getJSONArray(manyAssociationType.qualifiedName().name());
                    for (int i = 0; i < jsonValues.length(); ++i) {
                        String jsonValue = jsonValues.getString(i);
                        EntityReference value = jsonValue == JSONObject.NULL ? null : EntityReference.parseEntityReference((String)jsonValue);
                        references.add(value);
                    }
                    manyAssociations.put(manyAssociationType.qualifiedName(), references);
                }
                catch (JSONException e) {
                    manyAssociations.put(manyAssociationType.qualifiedName(), references);
                }
            }
            JSONObject namedAssocs = jsonObject.has("namedassociations") ? jsonObject.getJSONObject("namedassociations") : new JSONObject();
            HashMap namedAssociations = new HashMap();
            for (AssociationDescriptor namedAssociationType : entityDescriptor.state().namedAssociations()) {
                LinkedHashMap<String, EntityReference> references = new LinkedHashMap<String, EntityReference>();
                try {
                    JSONObject jsonValues = namedAssocs.getJSONObject(namedAssociationType.qualifiedName().name());
                    JSONArray names = jsonValues.names();
                    if (names != null) {
                        for (int idx = 0; idx < names.length(); ++idx) {
                            String name = names.getString(idx);
                            String jsonValue = jsonValues.getString(name);
                            references.put(name, EntityReference.parseEntityReference((String)jsonValue));
                        }
                    }
                    namedAssociations.put(namedAssociationType.qualifiedName(), references);
                }
                catch (JSONException e) {
                    namedAssociations.put(namedAssociationType.qualifiedName(), references);
                }
            }
            return new DefaultEntityState(version, modified, EntityReference.parseEntityReference((String)identity), status, entityDescriptor, properties, associations, manyAssociations, namedAssociations);
        }
        catch (JSONException e) {
            throw new EntityStoreException((Throwable)e);
        }
    }

    public JSONObject jsonStateOf(String id) throws IOException {
        JSONObject jsonObject;
        try (Reader reader = this.getValue(EntityReference.parseEntityReference((String)id)).getReader();){
            jsonObject = new JSONObject(new JSONTokener(reader));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        return jsonObject;
    }

    protected DatabaseSQLService.EntityValueResult getValue(EntityReference ref) {
        DatabaseSQLService.EntityValueResult entityValueResult;
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = this.database.getConnection();
            ps = this.database.prepareGetEntityStatement(connection);
            this.database.populateGetEntityStatement(ps, ref);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new EntityNotFoundException(ref);
            }
            entityValueResult = this.database.getEntityValue(rs);
        }
        catch (SQLException sqle) {
            try {
                throw new EntityStoreException("Unable to get Entity " + ref, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(rs);
                SQLUtil.closeQuietly(ps);
                SQLUtil.closeQuietly((Connection)connection);
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((ResultSet)rs);
        SQLUtil.closeQuietly((Statement)ps);
        SQLUtil.closeQuietly((Connection)connection);
        return entityValueResult;
    }

    protected void writeEntityState(DefaultEntityState state, Writer writer, String version) throws EntityStoreException {
        try {
            JSONWriter json = new JSONWriter(writer);
            JSONWriter properties = json.object().key("identity").value((Object)state.identity().identity()).key("application_version").value((Object)this.application.version()).key("type").value((Object)((Class)Iterables.first((Iterable)state.entityDescriptor().types())).getName()).key("version").value((Object)version).key("modified").value(state.lastModified()).key("properties").object();
            for (PropertyDescriptor persistentProperty : state.entityDescriptor().state().properties()) {
                Object value = state.properties().get(persistentProperty.qualifiedName());
                json.key(persistentProperty.qualifiedName().name());
                if (value == null || ValueType.isPrimitiveValue(value)) {
                    json.value(value);
                    continue;
                }
                String serialized = this.valueSerialization.serialize(value);
                if (serialized.startsWith("{")) {
                    json.value((Object)new JSONObject(serialized));
                    continue;
                }
                if (serialized.startsWith("[")) {
                    json.value((Object)new JSONArray(serialized));
                    continue;
                }
                json.value((Object)serialized);
            }
            JSONWriter associations = properties.endObject().key("associations").object();
            for (Map.Entry stateNameEntityReferenceEntry : state.associations().entrySet()) {
                EntityReference value = (EntityReference)stateNameEntityReferenceEntry.getValue();
                associations.key(((QualifiedName)stateNameEntityReferenceEntry.getKey()).name()).value((Object)(value != null ? value.identity() : null));
            }
            JSONWriter manyAssociations = associations.endObject().key("manyassociations").object();
            for (Map.Entry stateNameListEntry : state.manyAssociations().entrySet()) {
                JSONWriter assocs = manyAssociations.key(((QualifiedName)stateNameListEntry.getKey()).name()).array();
                for (EntityReference entityReference : (List)stateNameListEntry.getValue()) {
                    assocs.value((Object)entityReference.identity());
                }
                assocs.endArray();
            }
            JSONWriter namedAssociations = manyAssociations.endObject().key("namedassociations").object();
            for (Map.Entry stateNameMapEntry : state.namedAssociations().entrySet()) {
                JSONWriter assocs = namedAssociations.key(((QualifiedName)stateNameMapEntry.getKey()).name()).object();
                for (Map.Entry entry : ((Map)stateNameMapEntry.getValue()).entrySet()) {
                    assocs.key((String)entry.getKey()).value((Object)((EntityReference)entry.getValue()).identity());
                }
                assocs.endObject();
            }
            namedAssociations.endObject().endObject();
        }
        catch (JSONException e) {
            throw new EntityStoreException("Could not store EntityState", (Throwable)e);
        }
    }

    private static interface EntityStatesVisitor
    extends Visitor<EntityState, SQLException> {
    }
}

