/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.sql.assembly;

import java.io.IOException;
import org.qi4j.api.common.Visibility;
import org.qi4j.bootstrap.Assemblers;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.entitystore.sql.SQLEntityStoreService;
import org.qi4j.entitystore.sql.internal.DatabaseSQLService;
import org.qi4j.entitystore.sql.internal.DatabaseSQLServiceCoreMixin;
import org.qi4j.entitystore.sql.internal.DatabaseSQLServiceSpi;
import org.qi4j.entitystore.sql.internal.DatabaseSQLServiceStatementsMixin;
import org.qi4j.entitystore.sql.internal.DatabaseSQLStringsBuilder;
import org.qi4j.library.sql.common.SQLConfiguration;
import org.qi4j.spi.uuid.UuidIdentityGeneratorService;
import org.sql.generation.api.vendor.SQLVendor;
import org.sql.generation.api.vendor.SQLVendorProvider;

abstract class AbstractSQLEntityStoreAssembler<AssemblerType>
extends Assemblers.VisibilityIdentityConfig<AssemblerType> {
    public static final String DEFAULT_ENTITYSTORE_IDENTITY = "entitystore-sql";

    AbstractSQLEntityStoreAssembler() {
    }

    protected SQLVendor getSQLVendor() throws IOException {
        return SQLVendorProvider.createVendor(SQLVendor.class);
    }

    protected Class<?> getDatabaseStringBuilderMixin() {
        return DatabaseSQLStringsBuilder.CommonMixin.class;
    }

    protected abstract Class<?> getDatabaseSQLServiceSpecializationMixin();

    public final void assemble(ModuleAssembly module) throws AssemblyException {
        try {
            SQLVendor sqlVendor = this.getSQLVendor();
            if (sqlVendor == null) {
                throw new AssemblyException("SQL Vendor could not be determined.");
            }
            module.services(new Class[]{DatabaseSQLService.DatabaseSQLServiceComposite.class}).withMixins(new Class[]{DatabaseSQLServiceCoreMixin.class, DatabaseSQLServiceSpi.CommonMixin.class, this.getDatabaseStringBuilderMixin(), DatabaseSQLServiceStatementsMixin.class, this.getDatabaseSQLServiceSpecializationMixin()}).identifiedBy(this.hasIdentity() ? this.identity() : DEFAULT_ENTITYSTORE_IDENTITY).visibleIn(Visibility.module).setMetaInfo((Object)sqlVendor);
        }
        catch (IOException ioe) {
            throw new AssemblyException((Throwable)ioe);
        }
        module.services(new Class[]{SQLEntityStoreService.class, UuidIdentityGeneratorService.class}).visibleIn(this.visibility());
        if (this.hasConfig()) {
            this.configModule().entities(new Class[]{SQLConfiguration.class}).visibleIn(this.configVisibility());
        }
    }
}

