/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.sql.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.structure.Application;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.entitystore.sql.internal.DatabaseSQLService;
import org.qi4j.entitystore.sql.internal.DatabaseSQLServiceSpi;
import org.qi4j.entitystore.sql.internal.DatabaseSQLServiceState;
import org.qi4j.entitystore.sql.internal.DatabaseSQLStringsBuilder;
import org.qi4j.library.sql.common.SQLConfiguration;
import org.qi4j.library.sql.common.SQLUtil;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql.generation.api.vendor.SQLVendor;

public abstract class DatabaseSQLServiceCoreMixin
implements DatabaseSQLService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseSQLServiceCoreMixin.class);
    @Structure
    private Application application;
    @Service
    private DataSource dataSource;
    @This
    private DatabaseSQLServiceState state;
    @This
    protected DatabaseSQLServiceSpi spi;
    @This
    private DatabaseSQLStringsBuilder sqlStrings;
    @Uses
    private ServiceDescriptor descriptor;
    @This
    private Configuration<SQLConfiguration> configuration;

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDatabase() throws Exception {
        Statement stmt;
        Connection connection = this.getConnection();
        String schema = this.getConfiguredSchemaName("qi4j_es");
        if (schema == null) {
            throw new EntityStoreException("Schema name must not be null.");
        }
        this.state.schemaName().set((Object)schema);
        this.state.vendor().set(this.descriptor.metaInfo(SQLVendor.class));
        this.sqlStrings.init();
        if (!this.spi.schemaExists(connection)) {
            LOGGER.debug("Database Schema '{}' NOT found!", (Object)schema);
            stmt = null;
            try {
                stmt = connection.createStatement();
                for (String sql : this.sqlStrings.buildSQLForSchemaCreation()) {
                    stmt.execute(sql);
                }
            }
            finally {
                SQLUtil.closeQuietly((Statement)stmt);
            }
            LOGGER.debug("Database Schema '{}' created", (Object)schema);
        }
        if (!this.spi.tableExists(connection)) {
            stmt = null;
            try {
                stmt = connection.createStatement();
                for (String sql : this.sqlStrings.buildSQLForTableCreation()) {
                    stmt.execute(sql);
                }
                for (String sql : this.sqlStrings.buildSQLForIndexCreation()) {
                    stmt.execute(sql);
                }
            }
            finally {
                SQLUtil.closeQuietly((Statement)stmt);
            }
            LOGGER.trace("Table {} created", (Object)"qi4j_entities");
        }
        connection.setAutoCommit(false);
        SQLUtil.closeQuietly((Connection)connection);
    }

    @Override
    public void stopDatabase() throws Exception {
        if (Application.Mode.production == this.application.mode()) {
            // empty if block
        }
    }

    protected String getConfiguredSchemaName(String defaultSchemaName) {
        if (this.configuration == null) {
            NullArgumentException.validateNotNull((String)"default schema name", (Object)defaultSchemaName);
            LOGGER.debug("No configuration, will use default schema name: '{}'", (Object)defaultSchemaName);
            return defaultSchemaName;
        }
        String result = (String)((SQLConfiguration)this.configuration.get()).schemaName().get();
        if (result == null) {
            NullArgumentException.validateNotNull((String)"default schema name", (Object)defaultSchemaName);
            result = defaultSchemaName;
            LOGGER.debug("No database schema name in configuration, will use default: '{}'", (Object)defaultSchemaName);
        } else {
            LOGGER.debug("Will use configured database schema name: '{}'", (Object)result);
        }
        return result;
    }
}

