/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.sql.internal;

import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entity.ManyAssociationState;
import org.qi4j.spi.entity.NamedAssociationState;
import org.qi4j.spi.entitystore.helpers.DefaultEntityState;

public interface SQLEntityState
extends EntityState {
    public Long getEntityPK();

    public Long getEntityOptimisticLock();

    public DefaultEntityState getDefaultEntityState();

    public static final class DefaultSQLEntityState
    implements SQLEntityState {
        private final DefaultEntityState state;
        private final Long entityPK;
        private final Long entityOptimisticLock;

        public DefaultSQLEntityState(DefaultEntityState state) {
            NullArgumentException.validateNotNull((String)"Entity state", (Object)state);
            this.state = state;
            this.entityPK = null;
            this.entityOptimisticLock = null;
        }

        public DefaultSQLEntityState(DefaultEntityState state, Long entityPK, Long entityOptimisticLock) {
            NullArgumentException.validateNotNull((String)"Entity state", (Object)state);
            NullArgumentException.validateNotNull((String)"Entity PK", (Object)entityPK);
            NullArgumentException.validateNotNull((String)"Entity OptimisticLock", (Object)entityOptimisticLock);
            this.state = state;
            this.entityPK = entityPK;
            this.entityOptimisticLock = entityOptimisticLock;
        }

        @Override
        public Long getEntityPK() {
            return this.entityPK;
        }

        @Override
        public Long getEntityOptimisticLock() {
            return this.entityOptimisticLock;
        }

        @Override
        public DefaultEntityState getDefaultEntityState() {
            return this.state;
        }

        public EntityDescriptor entityDescriptor() {
            return this.state.entityDescriptor();
        }

        public EntityReference associationValueOf(QualifiedName stateName) {
            return this.state.associationValueOf(stateName);
        }

        public ManyAssociationState manyAssociationValueOf(QualifiedName stateName) {
            return this.state.manyAssociationValueOf(stateName);
        }

        public NamedAssociationState namedAssociationValueOf(QualifiedName stateName) {
            return this.state.namedAssociationValueOf(stateName);
        }

        public Object propertyValueOf(QualifiedName stateName) {
            return this.state.propertyValueOf(stateName);
        }

        public EntityReference identity() {
            return this.state.identity();
        }

        public boolean isAssignableTo(Class<?> type) {
            return this.state.isAssignableTo(type);
        }

        public long lastModified() {
            return this.state.lastModified();
        }

        public void remove() {
            this.state.remove();
        }

        public void setAssociationValue(QualifiedName stateName, EntityReference newEntity) {
            this.state.setAssociationValue(stateName, newEntity);
        }

        public void setPropertyValue(QualifiedName stateName, Object json) {
            this.state.setPropertyValue(stateName, json);
        }

        public EntityStatus status() {
            return this.state.status();
        }

        public String version() {
            return this.state.version();
        }

        public boolean equals(Object obj) {
            return this.state.equals(obj);
        }

        public int hashCode() {
            return this.state.hashCode();
        }

        public String toString() {
            return this.state.toString();
        }
    }
}

